
#    1725 with DPP - PSD

    set A32Base [third [split $AddressData :]]

    variable NumChans 16
    variable Name V1725PSD

   DefineRegister $Module xVME BoardInfo           "-a $A32Base -w 32 -o 0x8140 -p ro -d 32 -l 0 -b 0 -z x"

   set BoardInfo [ReadVMERegister $Module.BoardInfo]
   if {[string range $BoardInfo 6 end] != "dead"} {
       set FamilyCode [expr $BoardInfo & 0xff]
       set NumChans [expr ($BoardInfo >> 16) & 0xff]
   }

   DefineRegister $Module xVME ConfigReload        "-a $A32Base -w 32 -o 0xef34 -p wo -d 32"
   DefineRegister $Module xVME Clear               "-a $A32Base -w 32 -o 0xef28 -p wo -d 32"
   DefineRegister $Module xVME Reset               "-a $A32Base -w 32 -o 0xef24 -p wo -d 32"
   DefineRegister $Module xVME Scratch             "-a $A32Base -w 32 -o 0xef20 -p rw -d 32 -l 0 -b 0 -z x"

   DefineRegister $Module xVME FlashEnable         "-a $A32Base -w 32 -o 0xef2c -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME FlashData           "-a $A32Base -w 32 -o 0xef30 -p rw -d 32 -l 0 -b 0 -z x"

   DefineRegister $Module xVME BLTEventNum         "-a $A32Base -w 32 -o 0xef1c -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME VMEBaseAddress      "-a $A32Base -w 32 -o 0xef10 -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME MCSTBaseAddress     "-a $A32Base -w 32 -o 0xef0c -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME VMEStatus           "-a $A32Base -w 32 -o 0xef04 -p ro -d 32 -l 3 -b 0 -z x"
   DefineRegister $Module xVME VMEControl          "-a $A32Base -w 32 -o 0xef00 -p rw -d 32 -l 0 -b 0 -z d"

   DefineRegister $Module xVME Veto                "-a $A32Base -w 32 -o 0x817c -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME ExtTrigDisable      "-a $A32Base -w 32 -o 0x817c -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME BoardFailStatus     "-a $A32Base -w 32 -o 0x8178 -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME RunDelay            "-a $A32Base -w 32 -o 0x8170 -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME FirmWareLicense     "-a $A32Base -w 32 -o 0x8158 -p ro -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME MemBufFWM           "-a $A32Base -w 32 -o 0x816c -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME EventSize           "-a $A32Base -w 32 -o 0x814c -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME MonitorMode         "-a $A32Base -w 32 -o 0x8144 -p rw -d 32 -l 0 -b 0 -z d"
#   DefineRegister $Module xVME BoardInfo           "-a $A32Base -w 32 -o 0x8140 -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME ADCSync             "-a $A32Base -w 32 -o 0x813c -p wo -d 32"
   DefineRegister $Module xVME MonitorDAC          "-a $A32Base -w 32 -o 0x8138 -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME FPGARev             "-a $A32Base -w 32 -o 0x8124 -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME Enable              "-a $A32Base -w 32 -o 0x8120 -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME EventStored         "-a $A32Base -w 32 -o 0x812c -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME FPIOControl         "-a $A32Base -w 32 -o 0x811c -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME FPIOData            "-a $A32Base -w 32 -o 0x8118 -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME FPTrigOutEnable     "-a $A32Base -w 32 -o 0x8110 -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME TrigSrcEnable       "-a $A32Base -w 32 -o 0x810c -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME SoftTrig            "-a $A32Base -w 32 -o 0x8108 -p wo -d 32"
   DefineRegister $Module xVME AcqStatus           "-a $A32Base -w 32 -o 0x8104 -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME AcqControl          "-a $A32Base -w 32 -o 0x8100 -p rw -d 32 -l 0 -b 0 -z x"

   DefineRegister $Module xVME Calibration     "-a $A32Base -w 32 -o 0x809c -p ro -d 32"
   DefineRegister $Module xVME FanSpeed        "-a $A32Base -w 32 -o 0x8168 -p rw -d 32 -z x"
   DefineRegister $Module xVME AlmostFull      "-a $A32Base -w 32 -o 0x816c -p rw -d 32"
   DefineRegister $Module xVME BoardFail       "-a $A32Base -w 32 -o 0x8178 -p ro -d 32 -z x"
   DefineRegister $Module xVME ChShutDown      "-a $A32Base -w 32 -o 0x81c0 -p rw -d 32 -z x"
   DefineRegister $Module xVME ExtVetoDelay    "-a $A32Base -w 32 -o 0x81c4 -p rw -d 32"

   set ch 0
   for {set ijk 0} {$ijk < $NumChans/2} {incr ijk} {
       DefineRegister $Module xVME Ch$ch.TrigValMask    "-a $A32Base -w 32 -o [expr 0x8180+($ijk*4)] -p rw -d 32 -l 0 -b 0 -z x"
       incr ch
       DefineRegister $Module xVME Ch$ch.TrigValMask    "-a $A32Base -w 32 -o [expr 0x8180+($ijk*4)] -p rw -d 32 -l 0 -b 0 -z x"
       incr ch
   }

   DefineRegister $Module xVME BufferOrg           "-a $A32Base -w 32 -o 0x800c -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME ChCal               "-a $A32Base -w 32 -o 0x809c -p wo -d 32"
   DefineRegister $Module xVME ConfigClr           "-a $A32Base -w 32 -o 0x8008 -p wo -d 32"
   DefineRegister $Module xVME ConfigSet           "-a $A32Base -w 32 -o 0x8004 -p wo -d 32"
   DefineRegister $Module xVME Config              "-a $A32Base -w 32 -o 0x8000 -p rw -d 32 -l 0 -b 0 -z x"

   DefineRegister $Module xVME CustomSize        "-a $A32Base -w 32 -o 0x8020 -p wo -d 32"
   DefineRegister $Module xVME RecLen            "-a $A32Base -w 32 -o 0x8020 -p wo -d 32"
   DefineRegister $Module xVME DynRnge           "-a $A32Base -w 32 -o 0x8028 -p wo -d 32"
   DefineRegister $Module xVME EvtsPerBuf        "-a $A32Base -w 32 -o 0x8034 -p wo -d 32"
   DefineRegister $Module xVME PreTrig           "-a $A32Base -w 32 -o 0x8038 -p wo -d 32"
   DefineRegister $Module xVME CFD_Params        "-a $A32Base -w 32 -o 0x803c -p wo -d 32"
   DefineRegister $Module xVME DataFlush         "-a $A32Base -w 32 -o 0x8040 -p wo -d 32"
   DefineRegister $Module xVME ZeroThreshold     "-a $A32Base -w 32 -o 0x8044 -p wo -d 32"
   DefineRegister $Module xVME ShortGate         "-a $A32Base -w 32 -o 0x8054 -p wo -d 32"
   DefineRegister $Module xVME LongGate          "-a $A32Base -w 32 -o 0x8058 -p wo -d 32"
   DefineRegister $Module xVME PreGate           "-a $A32Base -w 32 -o 0x805c -p wo -d 32"
   DefineRegister $Module xVME Threshold         "-a $A32Base -w 32 -o 0x8060 -p wo -d 32"
   DefineRegister $Module xVME BaseLine          "-a $A32Base -w 32 -o 0x8064 -p wo -d 32"
   DefineRegister $Module xVME TrigWidth         "-a $A32Base -w 32 -o 0x8070 -p wo -d 32"
   DefineRegister $Module xVME TrigHoldOff       "-a $A32Base -w 32 -o 0x8074 -p wo -d 32"
   DefineRegister $Module xVME PSDThreshold      "-a $A32Base -w 32 -o 0x8078 -p wo -d 32"
   DefineRegister $Module xVME PUR-GAPThreshold  "-a $A32Base -w 32 -o 0x807c -p wo -d 32"
   DefineRegister $Module xVME AlgorithmControl  "-a $A32Base -w 32 -o 0x8080 -p wo -d 32"
   DefineRegister $Module xVME LocalTrigger      "-a $A32Base -w 32 -o 0x8084 -p wo -d 32"
   DefineRegister $Module xVME DPP_CTRL          "-a $A32Base -w 32 -o 0x8080 -p wo -d 32"
   DefineRegister $Module xVME DPP_CTRL2         "-a $A32Base -w 32 -o 0x8084 -p wo -d 32"
   DefineRegister $Module xVME DCOffset          "-a $A32Base -w 32 -o 0x8098 -p wo -d 32"
   DefineRegister $Module xVME ChSoftTrig        "-a $A32Base -w 32 -o 0x80c0 -p wo -d 32"
   DefineRegister $Module xVME VetoWidth         "-a $A32Base -w 32 -o 0x80d4 -p wo -d 32"
   DefineRegister $Module xVME BaseLineFreeze    "-a $A32Base -w 32 -o 0x80d8 -p wo -d 32"

   for {set ijk 0} {$ijk < $NumChans} {incr ijk} {
   DefineRegister $Module xVME Ch$ijk.CustomSize    "-a $A32Base -w 32 -o [expr 0x1020+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.RecLen        "-a $A32Base -w 32 -o [expr 0x1020+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.DynRnge  "-a $A32Base -w 32 -o [expr 0x1028+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.EvtsPerBuf    "-a $A32Base -w 32 -o [expr 0x1034+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.PreTrig       "-a $A32Base -w 32 -o [expr 0x1038+($ijk*0x100)] -p rw -d 32 -l 11 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.CFD_Params   "-a $A32Base -w 32 -o [expr 0x103c+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME Ch$ijk.CFD_Delay    "-a $A32Base -w 32 -o [expr 0x103c+($ijk*0x100)] -p rw -d 32 -l 8 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.CFD_Fraction "-a $A32Base -w 32 -o [expr 0x103c+($ijk*0x100)] -p rw -d 32 -l 2 -b 8 -z d"
   DefineRegister $Module xVME Ch$ijk.CFD_Xing     "-a $A32Base -w 32 -o [expr 0x103c+($ijk*0x100)] -p rw -d 32 -l 2 -b 10 -z d"
   DefineRegister $Module xVME Ch$ijk.DataFlush     "-a $A32Base -w 32 -o [expr 0x1040+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.ZeroThreshold "-a $A32Base -w 32 -o [expr 0x1044+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.ShortGate     "-a $A32Base -w 32 -o [expr 0x1054+($ijk*0x100)] -p rw -d 32 -l 10 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.LongGate      "-a $A32Base -w 32 -o [expr 0x1058+($ijk*0x100)] -p rw -d 32 -l 10 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.PreGate       "-a $A32Base -w 32 -o [expr 0x105c+($ijk*0x100)] -p rw -d 32 -l 8 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.Threshold     "-a $A32Base -w 32 -o [expr 0x1060+($ijk*0x100)] -p rw -d 32 -l 10 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.BaseLine      "-a $A32Base -w 32 -o [expr 0x1064+($ijk*0x100)] -p rw -d 32 -l 14 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.TrigWidth    "-a $A32Base -w 32 -o [expr 0x1070+($ijk*0x100)] -p rw -d 32 -l 10 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.TrigHoldOff  "-a $A32Base -w 32 -o [expr 0x1074+($ijk*0x100)] -p rw -d 32 -l 16 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.PSDThreshold "-a $A32Base -w 32 -o [expr 0x1078+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.PUR-GAPThreshold "-a $A32Base -w 32 -o [expr 0x107c+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.AlgorithmControl "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
#   DefineRegister $Module xVME Ch$ijk.LocalTrigger  "-a $A32Base -w 32 -o [expr 0x1084+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME Ch$ijk.DPP_CTRL      "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
#   DefineRegister $Module xVME Ch$ijk.DPP_CTRL2     "-a $A32Base -w 32 -o [expr 0x1084+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
#   DefineRegister $Module xVME Ch$ijk.ChStatus      "-a $A32Base -w 32 -o [expr 0x1088+($ijk*0x100)] -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME Ch$ijk.Status      "-a $A32Base -w 32 -o [expr 0x1088+($ijk*0x100)] -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME Ch$ijk.FPGARev       "-a $A32Base -w 32 -o [expr 0x108c+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module xVME Ch$ijk.DCOffset      "-a $A32Base -w 32 -o [expr 0x1098+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.ADCTemp    "-a $A32Base -w 32 -o [expr 0x10a8+($ijk*0x100)] -p ro -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.ChSoftTrig "-a $A32Base -w 32 -o [expr 0x10c0+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.VetoWidth   "-a $A32Base -w 32 -o [expr 0x10d4+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.BaseLineFreeze   "-a $A32Base -w 32 -o [expr 0x10d8+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z d"

   DefineRegister $Module xVME Ch$ijk.Charge      "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 3 -b 0 -z d"
   DefineRegister $Module xVME Ch$ijk.CoincMode   "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 2 -b 18 -z d"
   DefineRegister $Module xVME Ch$ijk.Polarity    "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 1 -b 16 -z d"
   DefineRegister $Module xVME Ch$ijk.BaseLineMean "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 3 -b 20 -z d"
   DefineRegister $Module xVME Ch$ijk.SelfTrig    "-a $A32Base -w 32 -o [expr 0x1080+($ijk*0x100)] -p rw -d 32 -l 1 -b 24 -z d"
   DefineRegister $Module xVME Ch$ijk.Extras      "-a $A32Base -w 32 -o [expr 0x1084+($ijk*0x100)] -p rw -d 32 -l 3 -b 8 -z d"

   }

   set ch 0
   for {set ijk 0} {$ijk < $NumChans} {incr ijk 2} {
       DefineRegister $Module xVME Ch$ch.LocalTrigger    "-a $A32Base -w 32 -o [expr 0x1084+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
       incr ch
       DefineRegister $Module xVME Ch$ch.LocalTrigger    "-a $A32Base -w 32 -o [expr 0x1084+($ijk*0x100)] -p rw -d 32 -l 0 -b 0 -z x"
       incr ch
   }

   for {set ijk 0} {$ijk <= 0x4c} {incr ijk 4} {
      DefineRegister $Module xVME ConfigROM[format %02x $ijk] "-a $A32Base -w 32 -o 0xf0[format %02x $ijk] -p r0 -d 32 -l 0 -b 0 -z x"
   }
   for {set ijk 0x80} {$ijk <= 0x84} {incr ijk 4} {
      DefineRegister $Module xVME ConfigROM[format %02x $ijk] "-a $A32Base -w 32 -o 0xf0[format %02x $ijk] -p r0 -d 32 -l 0 -b 0 -z x"
   }

   DefineRegister $Module xVME DataItem            "-a $A32Base -w 32 -o 0x0 -p ro -d 32 -l 0 -b 0 -z x"
   DefineRegister $Module bVME Output_Buffer         "-a $A32Base -w 32 -o 0x0 -p ro -d 32 -z x -l 1024"


puts "Defined $Module"
