

    proc do_Calibration {} {
       global NumChans

       set errflag1 0
       set errflag2 0

       InsertLog "Checking initial ADC calibration state"

       for {set n 0} {$n < $NumChans} {incr n} {

         set status [ReadRegister Ch$n.Status]
         if {[expr ($status >> 2) & 1] != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus not available; Cannot continue"
           incr errflag1
         }

         set status [ReadRegister Ch$n.Status]
         if {[expr ($status >> 3) & 1] == 0} {
           InsertLog "Channel $n Status  = $status: ADC Calibration has not been done"
           incr errflag2
         }
       }
         
       if {$errflag1 != 0} {return}
       if {$errflag2 == 0} {InsertLog "All ADC channels calibrated"}

       InsertLog "Running calibration for all channels"

       WriteRegister ADCCal 0

       InsertLog "Checking current ADC calibration state"

       set errflag1 0

       for {set n 0} {$n < $NumChans} {incr n} {

         for {set i 0} {$i < 10} {incr i} {

            set status [ReadRegister Ch$n.Status]
            if {[expr ($status >> 3) & 1] == 1} {break}

            after 100
         }

         if {$i == 10} {
            InsertLog "Channel $n Status = $status: ADC calibration not complete"
            incr errflag1
         }

         InsertLog "Calibration complete for channel $n"

       }

       InsertLog "ADC Calibration complete"
    }
 


