/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class BaseTextAreaUI
extends BasicTextAreaUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseTextAreaUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.updateBackground();
    }

    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(graphics);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.updateBackground();
        }
        super.propertyChange(propertyChangeEvent);
    }

    private void updateBackground() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getBackground() instanceof UIResource) {
            if (!jTextComponent.isEnabled() || !jTextComponent.isEditable()) {
                jTextComponent.setBackground(AbstractLookAndFeel.getDisabledBackgroundColor());
            } else {
                jTextComponent.setBackground(AbstractLookAndFeel.getInputBackgroundColor());
            }
        }
    }
}

