# str.tcl---Stretching spectra

# Wed Sep 14 15:05:52 BST 1994, DB
#   started by copying cut.tcl and modifying

package require ServerAccess 2.0
package require SpectrumClient

set started 0

set frame STR
set frametitle "Stretching (1d) Spectra"
set icontitle SpecStretch

set spectrum ""
set directory ""
set name ""
set autoshow 0
set factor 1.0
set shift 0.0
set limit 0
set base 0
set range 4096
set resultname ""
set resultdirectory ""
set action ""


proc file-front {n} {
   return [join [front [split $n "/"]] "/"]
}

proc file-last {n} {
   return [last [split $n "/"]]
}
    
proc repaint {} {
   global spectrum directory name autoshow limit base range 
   global limit
    :modify SPECTRUM   :value $spectrum
    :modify DIRECTORY  :value $directory
    :modify NAME       :value $name
    :modify AUTOSHOW   :value $autoshow
    :modify LIMIT      :value $limit
    :modify BASE       :value $base
    :modify RANGE      :value $range
}

proc confirm-action {s} {
   set m "Spectrum $s already exists\nPlease confirm that you want to overwrite it"
   return [midas-confirmation $m]
}

proc click-stretch {} {
   global debug spectrum directory name resultdirectory resultname action
   global factor shift base range limit autoshow EGallow

   clear-footer
   if {"$spectrum" == ""} then {
      set-footer "You haven't selected a spectrum yet!!!"; return}
   if {"$directory" == ""} then {set resultdirectory [file-front $spectrum]} \
                         else {set resultdirectory $directory}
   if {"$name" == ""} then {set resultname "[file-last $spectrum]*$factor+$shift"}\
                         else {set resultname $name}
   set action stretch
   set new [catch {eg "(spectrum :name '$resultdirectory/$resultname' ?spec)"}]
   if {$new == 0} then {
       if {[confirm-action $resultdirectory/$resultname] == 0} then {
          set-footer "action cancelled"
          return
       }
   }
   set limits ""
   if {$limit} then {set limits "-limit $base $range"}
   set-footer "Stretching $spectrum..."
   midas-check-for-temp

# is spectrum a SOAP path
   set sd [inform ex obtain_SOAPService_byName $spectrum]
   if {$sd != {}} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
     set ns [join [tail [split $spectrum /]] _]
     set ts [file join [pwd] $ns]
     catch {eg "(spectrum :path '$ts' !delete)"}
     catch {eval exec copy-soap-spectrum $spectrum $ts} m
   } else {
     set ts $spectrum
   }

   set rd [inform ex obtain_SOAPService_byName $resultdirectory]
   if {$rd != {}} {
      set rs [join [list [pwd] [set resultname]_Result] /]
      set z [catch {eg "(spectrum :name '$rs' !delete)"} m]
   } else {
     set rs [file join $resultdirectory $resultname]
   }
   set z [catch {eval exec specstretch\
      -spectrum $ts  -result $rs \
      -scale $factor -shift $shift $limits} m]
   if {$sd != {}} {
      set tmpAllow $EGallow; set EGallow 0x30000; EG "spectrum :path '$ts' !delete"; set EGallow $tmpAllow
   }
   if {$z == 0 && $rd != {}} {
      if {!$new} {set tmpAllow $EGallow; set EGallow 0x30000; EG "spectrum :path '[file join $resultdirectory $resultname]' !delete"; set EGallow $tmpAllow}
      set z [catch {eval exec copy-soap-spectrum $rs [file join $resultdirectory $resultname]} x]
      set tmpAllow $EGallow; set EGallow 0x30000; EG "spectrum :path '$rs' !delete"; set EGallow $tmpAllow
   }
   if {$z != 0} then {set-footer $m; return}
   set-footer "Stretched spectrum [file join $resultdirectory $resultname] created"
   send sb "redisplay-if-showing $resultdirectory"
   if {$autoshow} then {
      inform sd show [transparent [file join $resultdirectory $resultname]]
   }
}

proc click-default {w v} {
   global base range shift factor
   global spectrum directory name limit autoshow
   set [lowercase $w] $v
   clear-footer
}

proc click-redisplay {} {
   repaint
   clear-footer
}

proc start args {
   global started spectrum
   if {[llength $args] == 1} then {set args [first $args]}
   if {$started  == 0} then {make-frame; set started 1} else {open-frame}  
   if {[llength $args] > 0} then {set spectrum [first $args]}
   click-redisplay
}

proc make-frame {} {
   global env

   :frame [self frame-name] :label "[self frame-title]" :show-footer T  \
      :icon-image "@$env(ICONHOME)/spectrum"  \
      :icon-name [self icon-title]

    :panel P1 :layout V :pady 5 :padx 10
     :layout V
     :text SPECTRUM   :label "1d spectrum:" :w 32 :valuex 20c
     :text DIRECTORY  :label "Result directory:" :w 32 :valuex 20c
     :text NAME       :label "Result name:" :w 32 :valuex 20c
     :layout H; :col-gap 20
     :next-row T
     :text FACTOR     :label "Scale factor:" :w 6  :value 1.0 :valuex 20c
     :text SHIFT      :label "Shift:"        :w 6  :value 0.0
     :next-row T
     :checkbox AUTOSHOW :label "Show result:" :valuex 11c
     :next-row T
     :checkbox LIMIT  :label "Limit result:"  :valuex 11c
     :number BASE     :w 6   :max 8192
     :number RANGE    :w 6   :max 8192

    :panel P3 :layout V :pady 5 :padx 10
     :layout H; :row-gap 10; :col-gap 5
      :button STRETCH
      :hskip 140
      :button REDISPLAY;  :button HELP

  :show T
}

