
#    procedures specific to Analysis menu

set co(0) 1173.0; set co(1) 1332.0
set eu(0) 121.78; set eu(1) 244.69; set eu(2) 344.27; set eu(3) 778.90
set eu(4) 964.131; set eu(5) 1112.12; set eu(6) 1408.01
set euI(0) 1362.0; set euI(1) 358.0; set euI(2) 1275.0; set euI(3) 619.0
set euI(4) 692.0; set euI(5) 649.0; set euI(6) 1000.0
set peak(C) 0.0; set peak(deltaC) 0.0
set peak(E) 0.0; set peak(deltaE) 0.0
set peak(BA) 0.0; set peak(PA) 0.0; set peak(W) 0.0
set coef(A) 0.0; set coef(B) 0.0; set coef(C) 0.0; set coef(D) 0.0
set eudelta 20

set execute ""
set response ""

set reportflag 0
set abortflag 0

proc abort_report {} {
   global execute response abortflag

   set-footer "program terminated abnormally"
   set message "program terminated abnormally\n\
      \nexecuted: \"$execute\"\
      \nresponse received: \"$response\"\
      "
   if {[string length $message] < 1000} then {
      set abortflag [midas-confirmation "$message" "continue" "abort"]
   } else {
      midas-information "$message"
      set abortflag [midas-confirmation "report has been placed in separate window because of its size" "continue" "abort"]
   }
}

proc progress_report {w} {
   global execute response reportflag

   if {$reportflag == 0} then return

   if {$w == 0} then {
      midas-report "executed: \"$execute\"\
       \nresponse received: \"$response\"\
       "
   } else {
      midas-information "executed: \"$execute\"\
       \nresponse received: \"$response\"\
       "
   }
}

proc click-integrate ss {
  global execute response

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   set tags [get-tags 2]
   if {[llength $tags] < 2} then {
      set-footer "no limit channels selected!!!"
      clear-tags
      return
   }
   set currentchannel [second $tags]
   set lastchannel [first $tags]
   if {$currentchannel == $lastchannel} then {
      set-footer "two distinct limit channels required!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec integrate -spectrum $ts -limit $lastchannel $currentchannel"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        set st [string length "Integration of "]
        if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
        catch {eg "(spectrum :path '$ts' !delete)"}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0
      insert-log $m
      set-footer [string range $m [string last "Peak area" $m] end]
   }
   save-fit-tags $tags
   tidy-up
}

proc save-fit-tags tags {
   global fittags
   set fittags $tags
}

proc tidy-up {} {
   clear-tags
   clear-busy
#   clear-footer
}

proc click-peakfit {ss} {
   global backpeakoptions
   global execute response
   clear-fits
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   get-backpeak-options
   if {![info exists backpeakoptions(shapesfile)]} {set backpeakoptions(shapesfile) "no"}
   set tags [get-tags 99]
   if {[midas-check-for-temp] == 0} then {return}
   set tempfile backpeak-stderr
   set shapesfile backpeak-shapes
   zap-if-nan-present $shapesfile
   set-footer "Please wait... fitting..."
   set-busy
   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set use_shapesfile ""
      if {$backpeakoptions(shapesfile) == "yes"} {set use_shapesfile "-shapesfile $shapesfile"}
      set execute "exec backpeak  \
         -spectrum [transparent $ts] \
         -bgtype $backpeakoptions(backtype) \
         -peaktype $backpeakoptions(peaktype) \
         -weighting $backpeakoptions(weight) \
         -shape $backpeakoptions(shape) \
         -order $backpeakoptions(order) \
         -peaks $backpeakoptions(peaks) \
         -centroid compute \
         $use_shapesfile \
         -limit $tags \
         2> $tempfile"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
      }
      set response "$m"
      if {$z != 0} then {
         set e [file-contents $tempfile]
         set response "$m\n\n$e\n\
             \nUsage:  6 tags are required\
             \nfirst 2 define the peak to be fitted\
             \nremaining 4 define 2 background areas which must be on different sides of the peak"
         abort_report
         tidy-up
         return
      }
      progress_report 1

      set report [lindex $m [expr [llength $m]-1]]
      if {$sv != ""} {
        set st [string length "Background/Peak fit for spectrum "]
        set report [string replace $report $st [expr $st + [string length $ts] - 1] $s]
      }
      insert-log $report
      insert-log [file-contents $tempfile]
      inform cal "announce-fit [transparent $report]"
      if {[llength $ss] == 1} then {
         if {[llength $m] > 1} then {
              clear-fits
              update
              set z [catch {display-fit [first $m]} n]
              if {[llength $m] > 2} then {
#                   clear-fits; update
                   set z [catch {display-fit [second $m]} n]
              }
         }
      }
   }
   save-fit-tags $tags
   tidy-up
   clear-footer
}

proc get-backpeak-options {} {
   global backpeakoptions
   foreach i [get-eg-option backpeak] {
      set backpeakoptions([first $i]) [second $i]
   }
}

proc display-fit f {
   global gallery linestyleoptions
   set b [first [first $f]]
   set r [second [first $f]]
   set c [second $f]

   :spectrum $gallery spectrum overlap-dataset fit $b [expr $b + $r - 1]
   :spectrum $gallery spectrum data $b [expr $b + $r - 1] $c
   :spectrum $gallery spectrum linestyle $linestyleoptions(fit)

   update
}

proc click-brumfit {ss} {
   global  brumfitoptions
   global execute response
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   get-brumfit-options
   set tags [get-tags 99]
   if {[midas-check-for-temp] == 0} then {return}
   set tempfile brumfit-stderr
   set-busy
   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts [transparent $s]
      }

    set execute "exec brumfit  \
         -spectrum [transparent $ts] \
         -shape $brumfitoptions(shape) \
         -widthopt $brumfitoptions(widthopt) \
         -peakopt $brumfitoptions(peakopt) \
         -order $brumfitoptions(order) \
         -limit [first $tags] [second $tags] \
         -peaks [tail [tail $tags]] \
         -widths $brumfitoptions(widths) \
         -skews $brumfitoptions(skews) \
         2> $tempfile"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
      }
      set response "$m"
      if {$z != 0} then {
         set e [file-contents $tempfile]
         set response "$m\n\n$e"
         abort_report
         tidy-up
         return
      }
      progress_report 0
      set report [first $m]
      insert-log $report
      insert-log [file-contents $tempfile]
      inform cal "announce-fit [transparent $report]"
      if {[llength $m]>1} then {
         display-fit [second $m]
         if {[llength $m] > 2} then {display-fit [third $m]}
      }
   }
   save-fit-tags $tags
   tidy-up
   clear-footer
}

proc get-brumfit-options {} {
   global brumfitoptions
   foreach i [get-eg-option brumfit] {
      set brumfitoptions([first $i]) [second $i]
   }
}

proc click-calibrate ss {
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   inform cal "start [first $ss]"
}

proc click-peak/total ss {
   global execute response
   set tags [get-tags 99]
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   set-busy
   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec peak-to-total  \
         -spectrum [transparent $ts] \
         -limit $tags"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
        set st [string length "Peak-to-Total for spectrum "]
        if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0
      insert-log $m
      set-footer [string range $m [string last "Peak/Total" $m] end]
   }
   save-fit-tags $tags
   tidy-up
}


proc click-max-counts ss {
   global env execute response

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec max-counts -spectrum $ts"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
        if {$z == 0} {set m [string replace $m 0 [string length $ts] $s]}
      }
      set response "$m"
      if {$z!=0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

#      if {$env(MIDASUSEORBIX) == "true"} then {
 # note: this line suppresses ORBIX messages!!!
#         set m [first [lrange [split $m \n] end end]]
#      }
      insert-log $m
      set-footer "maximum channel counts in $m"
   }
   tidy-up
}

proc click-range-max ss {
   global env execute response

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   set tags [get-tags 2]
   if {[llength $tags] < 2} then {
      set currentchannel -1
      set lastchannel -1
      set mess "all channels"
   }  else  {
      set currentchannel [second $tags]
      set lastchannel [first $tags]
      set mess "channel $lastchannel to $currentchannel inclusive"
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec max-counts -limit $lastchannel $currentchannel \
                 -spectrum $ts"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
        if {$z == 0} {set m [string replace $m 0 [string length $ts] $s]}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

#      if {$env(MIDASUSEORBIX) == "true"} then {
 # note: this line suppresses ORBIX messages!!!
#         set m [first [lrange [split $m \n] end end]]
#      }

      set-footer "max counts in $m ($mess)"
      insert-log "$m ($mess)"
   }
   if {[llength $tags] == 2} then {
      save-fit-tags $tags
   }
   tidy-up
}

proc click-total-counts ss {
   global env execute response

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec total-counts -spectrum $ts"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
        if {$z == 0} {set m [string replace $m 0 [string length $ts] $s]}
      }
      set response "$m"
      if {$z!=0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

#      if {$env(MIDASUSEORBIX) == "true"} then {
 # note: this line suppresses ORBIX messages!!!
#         set m [first [lrange [split $m \n] end end]]
#      }
      insert-log $m
      set-footer "total counts in $m"
   }
   tidy-up
}

proc click-range-counts ss {
   global env execute response

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   set tags [get-tags 2]
   if {[llength $tags] < 2} then {
      set currentchannel -1
      set lastchannel -1
      set mess "all channels"
   }  else  {
      set currentchannel [second $tags]
      set lastchannel [first $tags]
      set mess "channel $lastchannel to $currentchannel inclusive"
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec total-counts -limit $lastchannel $currentchannel \
                 -spectrum $ts"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
        catch {eg "(spectrum :path '$ts' !delete)"}
        if {$z == 0} {set m [string replace $m 0 [string length $ts] $s]}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

#      if {$env(MIDASUSEORBIX) == "true"} then {
 # note: this line suppresses ORBIX messages!!!
#         set m [first [lrange [split $m \n] end end]]
#      }

      set-footer "counts in $m ($mess)"
      insert-log "$m ($mess)"
   }
   if {[llength $tags] == 2} then {
      save-fit-tags $tags
   }
   tidy-up
}

proc click-Co60-peak-to-total ss {
   global execute response
   global centroid co
   set tags [get-tags 4]
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $tags] != 4} then {
      set-footer "Co60 peak/total requires two peak regions (4 tags)!!!"
      clear-tags
      return
   }
   set tags [numeric-sort $tags]
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec integrate  \
         -spectrum [transparent $ts] \
         -limit [first $tags] [second $tags]"
      set z [catch {eval $execute} m]
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         return
      }
      progress_report 0
      set c1 [parse-integrate [map split-at-equal [split $m ",\n"]]]
      set execute "exec integrate  \
         -spectrum [transparent $ts] \
         -limit [third $tags] [fourth $tags]"
      set z [catch {eval $execute} m]
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         return
      }
      progress_report 0
      set c2 [parse-integrate [map split-at-equal [split $m ",\n"]]]
      set execute "exec calibrate -spectrum $ts \
         -opt linear  -units keV \
         << [make-cal-input $c1 $co(0) $c2 $co(1)]"
#      set z [catch {eval $execute} m]
      set z [catch {exec calibrate -spectrum $ts \
         -opt linear  -units keV \
         << [make-cal-input $c1 $co(0) $c2 $co(1)] } m]
      if {$sv != ""} {
         set st [string length "Calibration of spectrum "]
         if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0
      insert-log $m
      set execute "exec peak-to-total  \
         -spectrum $ts \
         -limit [first $tags] [second $tags] [third $tags] [fourth $tags]"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
         set st [string length "Peak-to-Total for spectrum "]
         if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
         catch {eg "(spectrum :path '$s' !delete)"}
         catch {eval exec copy-soap-spectrum $ts $s}
         catch {eg "(spectrum :path '$ts' !delete)"}
         refresh-once
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0
      insert-log $m
      set ptot [parse-peak-to-total [map split-at-colon [split $m ",\n"]]]
      set-footer "peak-to-total ratio for $s is $ptot"
   }
   save-fit-tags $tags
   update-calibrations
   tidy-up
}


proc update-calibrations {} {
   global gallery
   if {[info vars gallery] == "gallery"} then {
     catch {
       :spectrum $gallery refresh calibrations
       :spectrum $gallery refresh tags
     }
   }
   return
}

proc map {p ss} {
   set ll {}
   foreach s $ss {lappend ll [$p $s]}
   return $ll
}

proc split-at-equal s {split $s "="}

proc split-at-colon s {split $s ":"}

proc numeric-sort nn {
   set a0 [lindex $nn 0]
   set a1 [lindex $nn 1]
   set a2 [lindex $nn 2]
   set a3 [lindex $nn 3]
   while {1} {
      if {$a1 < $a0} then {set t $a1; set a1 $a0; set a0 $t; continue}
      if {$a2 < $a1} then {set t $a2; set a2 $a1; set a1 $t; continue}
      if {$a3 < $a2} then {set t $a3; set a3 $a2; set a2 $t; continue}
      return [list $a0 $a1 $a2 $a3]
   }
}

proc make-cal-input {c1 e1 c2 e2} {
   set ll ""
   append ll "$c1  $e1 0.1 0.1 \n"
   append ll "$c2  $e2 0.1 0.1 \n"
   return $ll
}

proc parse-peak-to-total pp {

   foreach p $pp {
      if {[llength $p] < 2} then {continue}
      set value 0.0
      set label [trim [first $p]]
      set value [scan-float [second $p]]
      if {$label=="Peak/Total"}      then {return $value}
      if {$label=="Energy"}          then {set timebar $value}
      if {$label=="Background area"} then {set backgroundarea $value}
      if {$label=="Peak area"}       then {set peakarea $value}
   }
   midas-warning "Can't find Peak/Total in output from peak-to-total!!!\n\n$pp\n"
}

proc trim s {string trim $s}

proc scan-float s {
   set f 0.0
   scan $s "%f" f
   return $f
}

proc parse-integrate pp {

   foreach p $pp {
      if {[llength $p] < 2} then {continue}
      set value 0.0
      set label [trim [first $p]]
      set value [scan-float [second $p]]
      if {$label=="Centroid"}        then {return $value}
      if {$label=="Energy"}          then {set timebar $value}
      if {$label=="Background area"} then {set backgroundarea $value}
      if {$label=="Peak area"}       then {set peakarea $value}
      if {$label=="Peak width"}      then {set peakwidth $value}
   }
   midas-warning "can't find Centroid in output from integrate!!!\n\n$pp\n"
}

proc parse-peak-integrate pp {
   global peak
   foreach p $pp {
      if {[llength $p] < 2} then {continue}
      set value 0.0; set value2 0.0
      set label [trim [first $p]]
      set value [scan-float [second $p]]
      set vals [split [second $p] "/"]
      if {[llength $vals] >= 2} then \
         {set value2 [scan-float [string trimleft [second $vals] "-"]]}
      if {$label=="Centroid"} then \
         {set peak(C) $value; set peak(deltaC) $value2}
      if {$label=="Energy"} then \
         {set peak(E) $value; set peak(deltaE) $value2}
      if {$label=="Background area"} then {set peak(BA) $value}
      if {$label=="Peak area"} then {set peak(PA) $value}
      if {$label=="Peak width"} then {set peak(W) $value}
   }
}

proc click-Co60-auto-calibration ss {
   global env abortflag execute response autocalibrateoptions
   global centroid co coef peak

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   get-autocalibrate-options
   set minchan  $autocalibrateoptions(low-chan)
   set maxchan  $autocalibrateoptions(high-chan)

   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
   foreach s $ss {
      insert-log "\nCo60 calibration for $s"
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set abortflag 0
      set hw 10
      set-footer "finding Cobalt peaks..."
# note: avoid counts in channel 0 which can be overflows
      set execute "exec peaklist -spectrum $ts -limit $minchan $maxchan -peaks 2"
      set z [catch {eval $execute} m]
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         if {$abortflag == 0} then {continue} else {break}
      }
      progress_report 0

      if {[llength $m] != 2} then {
         set response "Unable to locate required Cobalt peaks\
           \nin spectrum $s\n\
           \n[llength $m] peaks were located at $m\n\
           \nIs this really a Co60 spectrum?"
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         if {$abortflag == 0} then {continue} else {break}
      }

      set tags [lsort -integer $m]
      set centroids {}
      set deltacentroids {}
      set widths {}
      set peakareas {}
      foreach i {0 1} {
         set c [lindex $tags $i]
         set c1 [expr $c-$hw]
         set c2 [expr $c+$hw]
         set-footer "taking $co($i)keV peak centroid at channel $c..."
         set execute "exec integrate -spectrum $ts -limit $c1 $c2"
         set z [catch {eval $execute} m]
         set response "$m"
         if {$z!=0} then {
            abort_report
            incr abortflag
            tidy-up
            if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
            break
         }
         progress_report 0

         parse-peak-integrate [map split-at-equal [split $m ",\n"]]
         lappend centroids $peak(C)
         lappend deltacentroids $peak(deltaC)
         lappend widths $peak(W)
         lappend peakareas $peak(PA)
      }
      if {$abortflag == 1} then {continue}
      if {$abortflag == 2} then {break}

      set-footer "computing calibration..."
      set energies [list $co(0) $co(1)]
      set execute "exec calibrate -spectrum $ts \
         -opt linear  -units keV \
         << [make-calibrate-input $centroids $deltacentroids $energies]"
#      set z [catch {eval $execute} m]
      set z [catch {exec calibrate -spectrum $ts \
         -opt linear  -units keV \
         << [make-calibrate-input $centroids $deltacentroids $energies] } m]
      if {$sv != ""} {
         set st [string length "Calibration of spectrum "]
         if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
         catch {eg "(spectrum :path '$s' !delete)"}
         catch {eval exec copy-soap-spectrum $ts $s}
         refresh-once
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$abortflag == 0} then {continue} else {break}
      }
      progress_report 0

      insert-log $m
      parse-calibrate [map split-at-equal [split $m ",\n"]]
      update-calibrations

      set-footer "computing peak/total ratio..."
      set c1 [expr [first $tags]-$hw]
      set c2 [expr [first $tags]+$hw]
      set c3 [expr [second $tags]-$hw]
      set c4 [expr [second $tags]+$hw]
      set execute "exec peak-to-total -spectrum $ts -limit $c1 $c2 $c3 $c4"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
         set st [string length "Peak-to-Total for spectrum "]
         if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
         catch {eg "(spectrum :path '$ts' !delete)"}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$abortflag == 0} then {continue} else {break}
      }
      progress_report 0

      insert-log $m
      set ptot [parse-peak-to-total [map split-at-colon [split $m ",\n"]]]

      set f [lindex $widths 1]
      set R [expr $coef(B)*$f]
      set-footer "P/T=$ptot, at $co(1)keV: FWHM=$f channels, resolution=${R}keV"
      insert-log "$s: P/T=$ptot, at $co(1)keV: FWHM=$f channels, resolution=${R}keV"
   }
   clear-busy
}


proc make-calibrate-input {cs deltacs es} {
   set lines ""
   for {set i 0} {$i < [llength $cs]} {incr i} {
      append lines "[lindex $cs $i] [lindex $es $i] [lindex $deltacs $i] 0.1 \n"
   }
   return $lines
}



proc parse-calibrate pp {
   global coef
   foreach p $pp {
      if {[llength $p] < 2} then {continue}
      set value 0.0
      set value2 0.0
      set label [trim [first $p]]
      set value [scan-float [second $p]]
      set vals [split [second $p] "/"]
      if {[llength $vals] >= 2} then {
         set value2 [scan-float [string trimleft [second $vals] "-"]]
      }
      if {$label == "A"} then {
         set coef(A) $value
         set coef(deltaA) $value2
      }
      if {$label == "B"} then {
         set coef(B) $value
         set coef(deltaB) $value2
      }
      if {$label == "C"} then {
         set coef(C) $value
         set coef(deltaC) $value2
      }
      if {$label == "D"} then {
         set coef(D) $value
         set coef(deltaD) $value2
      }
   }
}


proc click-Eu152-auto-calibration ss {
   global execute abortflag response env  autocalibrateoptions
   global centroid eu euI peak coef

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   get-autocalibrate-options
   set minpeaks $autocalibrateoptions(Eu-minpeaks)
   set maxpeaks $autocalibrateoptions(Eu-maxpeaks)
   set minchan  $autocalibrateoptions(low-chan)
   set maxchan  $autocalibrateoptions(high-chan)
   set accept   $autocalibrateoptions(Eu-accept)
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
   foreach s $ss {
      insert-log "\nEu152 calibration for $s"
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set abortflag 0
      set hw 10
      set-footer "finding Europium peaks..."
# note: avoid counts in channel 0 which can be overflows
      set execute "exec peaklist -spectrum $ts -limit $minchan $maxchan -peaks $maxpeaks"
      set z [catch {eval $execute} m]
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         if {$abortflag == 0} then {continue} else {break}
      }
      progress_report 0

      if {[llength $m] < $minpeaks} then {
         set response "Unable to locate required Europium peaks\
           \nin spectrum $s\n\
           \n[llength $m] peaks were located at $m\n\
           \nIs this really an Eu152 spectrum?"
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         if {$abortflag == 0} then {continue} else {break}
      }
      set-footer "Found [llength $m] peaks"
      insert-log "Found [llength $m] peaks"

#    if $minpeaks is less than 7 then we drop essential peaks from low energy end
#    mostly this means that  peaks = 6  causes the 121KeV peak to be skipped
#    the rightmost peak is invariably the 1408keV line

      set tags {}
      set centroids {}
      set deltacentroids {}
      set widths {}
      set peakareas {}
      set energies {}
      set efficiencies {}

      if {$minpeaks < 7} then {
          set lowpeak [expr 7 - $minpeaks]
      } else {
          set lowpeak 0
      }
      set c6 [list-max $m]
      for {set i $lowpeak} {$i <= 6} {incr i} {
         set tag [list-nearest $m [expr $eu($i)/$eu(6)*$c6] $accept]
         if {$tag < 0} then {
            set response "Unable to locate all $minpeaks required Europium peaks\
              \nin spectrum $s\n\
              \n[llength $m] peaks were located at $m\n\
              \nIs this really an Eu152 spectrum?"
            abort_report
            incr abortflag
            tidy-up
            if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
            break
         }
         lappend tags $tag
      }
      if {$abortflag == 1} then {continue}
      if {$abortflag == 2} then {break}
      
      set j 0
      for {set i $lowpeak} {$i <= 6} {incr i} {
         set c [lindex $tags $j]
         set c1 [expr $c-$hw]
         set c2 [expr $c+$hw]
         set-footer "taking $eu($i)keV peak centroid at channel $c..."
         set execute "exec integrate -spectrum $ts -limit $c1 $c2"
         set z [catch {eval $execute} m]
         set response "$m"
         if {$z!=0} then {
            abort_report
            incr abortflag
            tidy-up
            if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
            break
         }
         progress_report 0

         parse-peak-integrate [map split-at-equal [split $m ",\n"]]
         lappend centroids $peak(C)
         lappend deltacentroids $peak(deltaC)
         lappend widths $peak(W)
         lappend peakareas $peak(PA)
         incr j
      }
      if {$abortflag == 1} then {continue}
      if {$abortflag == 2} then {break}

      set-footer "computing calibration..."

      for {set i $lowpeak} {$i <= 6} {incr i} {lappend energies $eu($i)}
      set execute "exec calibrate -spectrum $ts \
         -opt linear  -units keV \
         << [make-calibrate-input $centroids $deltacentroids $energies]"
#      set z [catch {eval $execute} m]
      set z [catch {exec calibrate -spectrum $ts \
         -opt linear  -units keV \
         << [make-calibrate-input $centroids $deltacentroids $energies] } m]
      if {$sv != ""} {
         set st [string length "Calibration of spectrum "]
         if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
         catch {eg "(spectrum :path '$s' !delete)"}
         catch {eval exec copy-soap-spectrum $ts $s} nn
         catch {eg "(spectrum :path '$ts' !delete)"}
         refresh-once
      }

      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$abortflag == 0} then {continue} else {break}
      }
      progress_report 0

      insert-log $m
      update-calibrations

#    put tags at located peaks
      if {$s == [select spectrum]} then {
          clear-tags
          set j 0
          for {set i $lowpeak} {$i <= 6} {incr i} {
              make-tag [lindex $centroids $j]
              incr j
          }
      }

      parse-calibrate [map split-at-equal [split $m ",\n"]]

#  compute efficiencies at each peak
      set j 0
      for {set i $lowpeak} {$i <= 6} {incr i} {
         set N [lindex $peakareas $j]
         set N6 [last $peakareas]
         set I $euI($i)
         lappend efficiencies [expr ($N/$N6)/($I/1000.0)]
         incr j
      }

      set f [last $widths]
      set R [expr ($coef(B)+2.0*$coef(C)*$c6)*$f]
      set-footer "at $eu(6)keV: FWHM=$f channels, resolution=${R}keV"
      insert-log "$s: at $eu(6)keV: FWHM=$f channels, resolution=${R}keV"
   }
   clear-busy
}

proc get-autocalibrate-options {} {
   global autocalibrateoptions
   foreach i [get-eg-option autocalibrate] {
      set autocalibrateoptions([first $i]) [second $i]
   }
}

proc list-max s {
   set m [first $s]
   foreach i $s {if {$i > $m} then {set m $i}}
   return $m
}

proc list-min-index s {
   set m [first $s]
   set i 0
   set j 0
   foreach n $s {if {$n < $m} then {set m $n; set j $i}; incr i}
   return $j
}

proc list-nearest {s v d} {
   set ds {}
   foreach i $s {lappend ds [abs [expr $v-$i]]}
   set i [list-min-index $ds]
   set dd [lindex $ds $i]
   if {$dd > $d} then {
      midas-warning "attempting to find peak at about channel $v\n\
         \nclosest is [lindex $s $i]\ndelta is $dd which exceeds limit of $d"
      return -1
   }
#   midas-report "attempting to find peak at about channel $v\n\
#     \nclosest is [lindex $s $i]\ndelta is $dd which is within limit of $d"
   return [lindex $s $i]
}

proc abs x {if {$x>=0} then {return $x} else {return [expr 0-$x]}}

proc click-peakfind ss {
   global execute response peakfindoptions
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   get-peakfind-options
   foreach s $ss {
      set-footer "finding peaks in $s..."
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec peakfind \
        -spectrum [transparent $ts] \
        -limit $peakfindoptions(low-chan) $peakfindoptions(high-chan) \
        -fwhm $peakfindoptions(fwhm) \
        -accept $peakfindoptions(accept)"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
         set st [string length "Peak finding for "]
         if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
         catch {eg "(spectrum :path '$ts' !delete)"}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

      insert-log $m
   }
   if {$s == [select spectrum]} then {
      clear-tags
      foreach c [parse-peakfind $m] {make-tag $c}
   }
   clear-footer
}

proc parse-peakfind {stuff} {
   set lines [split $stuff "\n"]
   set ll {}
   foreach line [lreplace $lines 0 1] {
      if {[scan $line "%d %f" i c]==2} then {lappend ll [round $c]}
   }
   return $ll
}

proc round x {scan [expr $x+0.5] %d n; return $n}

proc get-peakfind-options {} {
   global peakfindoptions
   foreach i [get-eg-option peakfind] {
      set peakfindoptions([first $i]) [second $i]
   }
}

proc click-plot ss {
   global execute response specplotoptions peakfindoptions

   get-specplot-options
   if {$specplotoptions(peaks)} then {get-peakfind-options}

   set nulldev [get-eg-option nulldevice]
   set regionlist $specplotoptions(gains)
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}

   if {[midas-check-for-temp] == 0} then {return}
   set channelfile plot-channels
   set-busy
   foreach s $ss {
      set-footer "plotting $s..."
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      if {$specplotoptions(peaks)} then {
         set-footer "finding peaks in $s..."
         set execute "exec peakfind \
           -spectrum [transparent $ts] \
           -limit $peakfindoptions(low-chan) $peakfindoptions(high-chan) \
           -fwhm $peakfindoptions(fwhm) \
           -accept $peakfindoptions(accept)"
         set z [catch {eval $execute} m]
         if {$sv != ""} {
            set st [string length "Peak finding for "]
            if {$z == 0} {set m [string replace $m $st [expr $st + [string length $ts] - 1] $s]}
         }
         set response "$m"
         if {$z != 0} then {
            abort_report
            tidy-up
            if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
            return
         }
         progress_report 0

         set pp "$channelfile"
         parse-peakfind-to-file $m $pp
      }  else {
         set pp $nulldev
      }
      set ff specplot.ps
      set-footer "plotting $s into $ff ..."
      set lc $specplotoptions(low-chan)
      set hc $specplotoptions(high-chan)
       set yrange [expr [fourth [first $regionlist]] - [third [first $regionlist]]+1]
      set execute " exec specplot  \
         -spectrum [transparent $ts] \
         -strips $specplotoptions(strips) \
         -xincr $specplotoptions(scale) \
         -limit $lc [expr $hc-$lc+1] [third [first $regionlist]] $yrange \
         -nsector [llength $regionlist] \
         -gain [make-plot-gains $regionlist] \
         -changegain [make-plot-changes $regionlist] \
         -norm $specplotoptions(norm) \
          < $pp > $ff 2> $nulldev"
      set z [catch {eval $execute} m]
      if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

      print-postscript $ff
   }
   clear-busy
}

proc make-plot-gains rs {
   set ll {}
   set gain [fourth [first $rs]]
   foreach r $rs {lappend ll [expr $gain/[fourth $r]]}
   return $ll
}

proc make-plot-changes rs {
   set ll {}
   foreach r $rs {lappend ll [second $r]}
   return $ll
}

proc parse-peakfind-to-file {stuff file} {
   set lines [split $stuff "\n"]
   set f [open $file w]
   foreach line [lreplace $lines 0 1] {
      if {[scan $line "%d %f" i c]==2} then {puts $f "$c"}
   }
   close $f
}

proc get-specplot-options {} {
   global specplotoptions
   foreach i [get-eg-option specplot] {
      set specplotoptions([first $i]) [second $i]
   }
   set p {}
   foreach t $specplotoptions(gains) {
     lappend p [list [first $t] [third $t] [second $t] [fourth $t]]
   }
   set specplotoptions(gains) $p
}

proc click-save-cuts {} {
   global frame gallery
   global $frame
   set z [catch {
      set cuts [set ${frame}(cuts)]
      set cutx [first $cuts]
      set cuty [second $cuts]
      :spectrum $gallery spectrum current $cutx
      set cutxtitle [:spectrum $gallery spectrum title]
      :spectrum $gallery spectrum current $cuty
      set cutytitle [:spectrum $gallery spectrum title]
   } m]
   if {$z != 0} then {
      set-footer "failed to save cuts: $m"
      return
   }

   set cutxname [first $cutxtitle]
   if {[inform ex obtain_SOAPService_byName $cutxname] == {}} {
# standard EGlib spectrum name (direct or SAS)
      set cutxfullname [join [list "EGlib" $cutxname] :]
   } else {
      set cutxfullname $cutxname
   }
   set cutyname [first $cutytitle]
   if {[inform ex obtain_SOAPService_byName $cutyname] == {}} {
# standard EGlib spectrum name (direct or SAS)
      set cutyfullname [join [list "EGlib" $cutyname] :]
   } else {
      set cutyfullname $cutyname
   }
   :spectrum $gallery spectrum current $cutx
   :spectrum $gallery spectrum save $cutxfullname
   :spectrum $gallery spectrum current $cuty
   :spectrum $gallery spectrum save $cutyfullname
   set z [catch {
      eg "(spectrum :name '$cutxname' ?spec)"
      eg "(spectrum :name '$cutyname' ?spec)"
   } m]
   if {$z != 0} then {
     if {$m != ""} {set m [eg "(sys :error $m ?message)"]}
     if {$m == "OK"} then {set-footer "failed to save cuts: no unsaved cuts"} \
        else {set-footer "failed to save cuts: $m"}
     return
   }

   set-footer "cuts saved"
   :spectrum $gallery spectrum clear
   :spectrum $gallery spectrum add $cutxfullname $cutyfullname
}

proc click-check-counts ss {
   global execute response
   set two30 [expr 1024*1024*1024]
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec fix-counts -spectrum $ts -opt check"
      set z [catch {eval $execute} m]
      if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

      set n [third $m]
      if {$n > 0} then {
         set-footer "at least one count $n > 2**30 (should be [expr $n-$two30-$two30]?) in $s"
      } else {
         set-footer "min: [first $m], max: [second $m], looks ok in $s"
      }
   }
   tidy-up
}

proc click-fix-counts ss {
   global execute response
   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   set-busy
   foreach s $ss {
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec fix-counts -spectrum $ts -opt fix"
      set z [catch {eval $execute} m]
      if {$sv != ""} {
         if {$z == 0 && [first $m] != "0"} {
            catch {eg "(spectrum :path '$s' !delete)"}
            catch {eval exec copy-soap-spectrum $ts $s}
            refresh-once
         }
         catch {eg "(spectrum :path '$ts' !delete)"}
      }
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         return
      }
      progress_report 0

      show $s
      set-footer "fixed [first $m] counts in $s"
   }
   tidy-up
}

proc file-contents {file} {
   set z [catch {open $file} f]
   if {$z != 0} then {midas-warning $f; return ""}
   set text [read $f]
   close $f
   return "$text"
}

proc zap-if-nan-present {f} {
   if {[file exists $f] == 0} then {return}
   catch {if {[regexp NaN [file-contents $f]]} then {:file delete $f}}
}


#    gainmatching from GAVSORT - courtesy Gavin Smith; Manchester

proc click-gainmatch ss {
   global env execute response gainmatchoptions gainmatchcoeffs

   if {[llength $ss] == 0 && [select spectrum] == ""} then {
      set-footer "no spectrum selected!!!"
      clear-tags
      return
   }
   if {[llength $ss] == 0} then {set ss [list [select spectrum]]}
   get-gainmatch-options
   switch  $gainmatchoptions(options) {
      0   {set options ""}
      1   {set options "-VERBOSE"}
      2   {set options "-ANALYSE"}
      3   {set options "-VERBOSE -ANALYSE"}
   }
   set report_failed ""
   set report_success "spectrum directory [file dirname [first $ss]]\n\n"
   append report_success "Gainmatch cofficients for each adc in this run are \n\n*\n"
   foreach s $ss {
      set-footer "finding peaks in $s..."
# is spectrum a SOAP path
      set sv [inform ex obtain_SOAPService_byName $s]
      if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
        set ns [join [tail [split $s /]] _]
        set ts [file join [pwd] $ns]
        catch {eg "(spectrum :path '$ts' !delete)"}
        catch {eval exec copy-soap-spectrum $s $ts} m
      } else {
        set ts $s
      }

      set execute "exec gainmatch \
        -spectrum [transparent $ts] \
        -config $gainmatchoptions(config) \
        -theta $gainmatchoptions(theta) \
        -velocity $gainmatchoptions(velocity) \
        -tolerance $gainmatchoptions(tolerance) \
        -xrayfilter $gainmatchoptions(xrayfilter) \
        -gain $gainmatchoptions(gain) \
        -wcal0 $gainmatchoptions(wcal0) \
        -wcal1 $gainmatchoptions(wcal1) \
        -polyorder [expr $gainmatchoptions(polyorder)+1] \
        $options"

      set z [catch {eval $execute} m]
      set response "$m"
      if {$z != 0} then {
         abort_report
         tidy-up
         if {$sv != ""} then { catch {eg "(spectrum :path '$ts' !delete)"} }
         return
      }
      progress_report 0

      insert-log $m
      foreach line [split $m "\n"]  {
          switch  -exact -- "[first $line]" {
             $Calculated  {
                set adc [last [split [lindex $line 3] /]]
                if {[last [split $adc .]] == "q0"} then {
                   set adc [string range $adc 0 [expr [string length $adc] - 4]]
                }
                if {[last [split $adc .]] == "q0+2"} then {
                   set adc [string range $adc 0 [expr [string length $adc] - 6]]
                }
                set c0 [lindex $line 6]
                set c1 [lindex $line 7]
                set c2 [lindex $line 8]
                append report_success "$adc \t $c0 \t $c1 \t $c2\n"
                set gainmatchcoeffs($adc) "$c0 $c1 $c2"
             }
             $Unable      {
                set adc [last [split [last $line] /]]
                if {[last [split $adc .]] == "q0"} then {
                   set adc [string range $adc 0 [expr [string length $adc] - 4]]
                }
                if {[last [split $adc .]] == "q0+2"} then {
                   set adc [string range $adc 0 [expr [string length $adc] - 6]]
                }
                append report_failed "Unable to calculate gainmatch coefficients for adc $adc\n"
                catch {unset gainmatchcoeffs($adc)}
             }
             default      {}
          }
      }
   }
   if {$s == [select spectrum]} then {
      clear-tags
      foreach c [parse-gainmatch $m] {make-tag $c}
   }
   if {[string length $report_success] > 0}  then {midas-information "$report_success"}
   if {[string length $report_failed] > 0}  then {
      if {[string length $report_failed] < 1000} then {
         midas-warning "$report_failed"
      } else {
         midas-information "$report_success\n\n$report_failed"
      }
   }

   clear-footer
}

#    for saving the gain match coefficients

set browserdirectory $env(HOME)
set browserfile  ""

proc make_NEOgainmatch_file {} {
    upvar #0  browserdirectory directory
    upvar #0  browserfile file

#    first the 4MeV data file
    set file "cal_coeffs_4MeV.dat"
    midas-browser W write_NEOgainmatch_file_4MeV

#    then the 20MeV data file
    set file "cal_coeffs_20MeV.dat"
    midas-browser W write_NEOgainmatch_file_20MeV
}

proc write_NEOgainmatch_file_4MeV {args}  {write_NEOgainmatch_file 4MeV}
proc write_NEOgainmatch_file_20MeV {args} {write_NEOgainmatch_file 20MeV}

#    procedure to make a gainmatch coefficient file in the format required by the Euroball NEO++ program
proc write_NEOgainmatch_file {w} {
    global gainmatchcoeffs
    upvar #0  browserdirectory directory
    upvar #0  browserfile file

#    argument is 4MeV or 20MeV

    if {$w == "4MeV"} then {set scale 0.5} else {set scale 2.5}

    set z [catch {open [file join $directory $file] w} f]
    if {$z != 0} then {midas-warning "Unable to write [file join $directory $file]\n$f"; return}

#    Cluster detectors

    for {set i 0} {$i <= 14} {incr i} {
        foreach j [list A B C D E F G] {
            if {[info exists gainmatchcoeffs(ClusterGe$i.Ge$j.$w)]} then {
                set c $gainmatchcoeffs(ClusterGe$i.Ge$j.$w)
            } else {
                set c "0.0 1.0 0.0"
            } 
            puts $f [format "%-12s%-12s%-12s%-20s" [expr [second $c] * $scale] [expr [first $c] * $scale] 0 ClusterGe$i.Ge$j]
        }
    }

#    Clover detectors

    for {set i 0} {$i <= 25} {incr i} {
        foreach j [list A B C D] {
            if {[info exists gainmatchcoeffs(Clover$i.Ge$j.$w)]} then {
                set c $gainmatchcoeffs(Clover$i.Ge$j.$w)
            } else {
                set c "0.0 1.0 0.0"
            }
            puts $f [format "%-12s%-12s%-12s%-20s" [expr [second $c] * $scale] [expr [first $c] * $scale] 0 Clover$i.Ge$j]
        }
    }

#    Tapered detectors

    for {set i 0} {$i <= 29} {incr i} {
        foreach j [list A] {
            if {[info exists gainmatchcoeffs(Ge$i.$w)]} then {
                set c $gainmatchcoeffs(Ge$i.$w)
            } else {
                set c "0.0 1.0 0.0"
            } 
            puts $f [format "%-12s%-12s%-12s%-20s" [expr [second $c] * $scale] [expr [first $c] * $scale] 0 Ge$i]
        }
    }

    close $f
}


proc make_EBgainmatch_file {} {
    upvar #0  browserdirectory directory
    upvar #0  browserfile file

#    first the 4MeV data file
    set file "gm_coeffs_4MeV.dat"
    midas-browser W write_EBgainmatch_file_4MeV

#    then the 20MeV data file
    set file "gm_coeffs_20MeV.dat"
    midas-browser W write_EBgainmatch_file_20MeV
}

proc write_EBgainmatch_file_4MeV {args}  {write_EBgainmatch_file 4MeV}
proc write_EBgainmatch_file_20MeV {args} {write_EBgainmatch_file 20MeV}


#    procedure to make a gainmatch coefficient file in the format required by John Smith
proc write_EBgainmatch_file {w} {
    global gainmatchcoeffs
    upvar #0  browserdirectory directory
    upvar #0  browserfile file

#    argument is 4MeV or 20MeV

    set z [catch {open [file join $directory $file] w} f]
    if {$z != 0} then {midas-warning "Unable to write [file join $directory $file]\n$f"; return}

#    Tapered detectors

    set det -1

    for {set i 0} {$i <= 29} {incr i} {
        foreach j [list A] {
            incr det
            if {[info exists gainmatchcoeffs(Ge$i.$w)]} then {
                set c $gainmatchcoeffs(Ge$i.$w)
            } else {
                set c "0.0 1.0 0.0"
            } 
            puts $f [format "%-12s%-12s%-12s" $det [second $c] [first $c]]
        }
    }

#    Clover detectors

    for {set i 0} {$i <= 25} {incr i} {
        foreach j [list A B C D] {
            incr det
            if {[info exists gainmatchcoeffs(Clover$i.Ge$j.$w)]} then {
                set c $gainmatchcoeffs(Clover$i.Ge$j.$w)
            } else {
                set c "0.0 1.0 0.0"
            }
            puts $f [format "%-12s%-12s%-12s" $det [second $c] [first $c]]
        }
    }

#    Cluster detectors

    for {set i 0} {$i <= 14} {incr i} {
        foreach j [list A B C D E F G] {
            incr det
            if {[info exists gainmatchcoeffs(ClusterGe$i.Ge$j.$w)]} then {
                set c $gainmatchcoeffs(ClusterGe$i.Ge$j.$w)
            } else {
                set c "0.0 1.0 0.0"
            }
            puts $f [format "%-12s%-12s%-12s" $det [second $c] [first $c]]
        }
    }

    close $f
}

proc parse-gainmatch {stuff} {
   set lines [split $stuff "\n"]
   set ll {}
   foreach line $lines {
      if {[first $line] == "peaks:"} then {lappend ll [string range $line 6 end]}
   }
   return [last $ll]
}

proc get-gainmatch-options {} {
   global gainmatchoptions
   foreach i [get-eg-option gainmatch] {
      set gainmatchoptions([first $i]) [second $i]
   }
}
