# sb.tcl---spectrum (directory) browser

#  June 30 1996  convert JRCs TK version to use TK library
# Fri Jul  8 17:03:52 BST 1994, SCL (Copied version)

package require ServerAccess
package require SpectrumClient

set frame  SB
set frametitle SB
set icontitle "DirBrowse"
set helpname sb

set started 0
foreach type [list normal sfm sort hist singles MemSas VMESas SortSas] {set [set type]started 0}

set frames {}

set normalframetitle  "Spectrum Directory Browser"
set sortframetitle    "Sort Spectrum Directory Browser"
set sfmframetitle     $sortframetitle
set histframetitle    "Histogram Spectrum Directory Browser"
set singlesframetitle "Singles Spectrum Directory Browser"
set current {}

set rowsize 0
set rowoverhead 0

set directory ""

set resource ""
set resources ""

set SOAPSpectrumRoles {Spectrum Hist}

set details 0
set sorttype numeric
set filelist {}

set online_sort 0
set sort_going 0

set debugsb 0

#    menus for the buttons

set normal-ACTIONs {"copy" "import" "export" "append msf suffix" "remove msf suffix" "add/change title" "save titles" "apply titles" "" "" "delete"}
set online-ACTIONs {save "" "" "just zero" "zero and deselect" "" "add/change title" "save titles" "apply titles" "" "" "delete"}


set optionsmenu {"names" "details" "alphabetic" "numeric" "unsorted"}

set analysismenu {"projecting" "stretching" "adding-up" "exporting" "importing" \
     "integrate" "peakfit" {"peakfit options..."} {calibrating {"calibrate"} {"save calibrations"} {"apply calibrations"}} peak/total \
 {"maximum channel counts"} {"range maximum"} {"total counts"} {"range counts"} {"Co60 peak/total"} \
     {auto-calibration {"Co60 auto-calibration"}  {"Eu152 auto-calibration"} {"auto-calibration options..."}} \
     "peakfind" {"peakfind options..."} \
     {gainmatching {"gainmatch"} {"gainmatch options..."} {"gainmatch setup"}} {plotting {"plot"} {"plot options..."}}}

set showingmenu {{"just show"} {"show and deselect"}}

set msfmenu {{Scan for spectra} {Use msf file suffix} {Show all files}}
set msf 0
set preferences(directory.usemsf) 0

set selectmode 0
set preferences(directory.selectmode) E



set patternmenu {""}

#-- spectrum resource list ------------

proc make-spec-resource-list {} {
   global SOAPSpectrumRoles

# build the original RPC list
   set z [catch {eg "(experiment ?resources)"} m]
   if {$z==0} then {set rs $m} else {set rs ""}
   set ll {direct}
   foreach r $rs {
#    first scan through resources and add role of all spectrum servers to the list
      set type [second [fourth $r]]
      set role [second [fifth $r]]
      if {$type == "spectrum"} then {
         if {[lsearch $ll $role] == -1} then {lappend ll $role}
      }
   }
   foreach r $rs {
#    next scan through resources and add instances of all spectrum servers to the list
      set type [second [fourth $r]]
      set role [second [fifth $r]]
      set name [second [first $r]]
      if {$role == "SortSas"} then {continue}
      if {$type == "spectrum"} then {lappend ll $name}
   }

# add the SOAP list

   foreach rl $SOAPSpectrumRoles {
      set ss [inform ex obtain_SOAPServers_byRole $rl]
      if {$ss == {}} then {continue}
      foreach s $ss {
         set rs [inform ex obtain_SOAPServerInfo $s $rl]
#    first scan through resources and add role of all spectrum servers to the list
         set name [first $rs]
         set role [third $rs]
#         set type [fourth $r]
         if {[lsearch $ll $role] == -1} then {lappend ll $role}

#    next scan through resources and add instances of all spectrum servers to the list
         if {$role == "SortSas"} then {continue}
         if {[lsearch $ll $name] == -1} then {lappend ll $name}
      }
   }

   return $ll
}

proc make-hist-resource-list {} {
  global env
  global SOAPSpectrumRoles

   set z [catch {eg "(experiment ?resources)"} m]
   if {$z==0} then {set rs $m} else {set rs ""}

   set ll {}
   if {[info exists env(HwreHistServer)] == 0} then {lappend ll hist}  \
      else {lappend ll $env(HwreHistServer)}

   foreach r $rs {
#    next scan through resources and add instances of all hist spectrum servers to the list
      set type [second [fourth $r]]
      set role [second [fifth $r]]
      set name [second [first $r]]
      if {$type == "spectrum" && $role == "hist"} then {lappend ll $name}
   }

   set ss [inform ex obtain_SOAPServers_byRole "Hist"]
   if {$ss == {}} then {continue}
   set rs [inform ex obtain_SOAPServerInfo $ss "Hist"]
   if {$rs != {}} then {lappend ll "Hist"}
   foreach r $rs {
#    next scan through resources and add instances of all Hist spectrum servers to the list
      set name [first $r]
#      set role [third $r]
#      set type [fourth $r]
      lappend ll $name
   }

   return $ll
}

proc make-singles-resource-list {} {
  global env

   set z [catch {eg "(experiment ?resources)"} m]
   if {$z==0} then {set rs $m} else {set rs ""}

   set ll {}
   if {[info exists env(SinglesServer)] == 0} then {lappend ll singles}  \
      else {lappend ll $env(SinglesServer)}

   foreach r $rs {
#    next scan through resources and add instances of all singles spectrum servers to the list
      set type [second [fourth $r]]
      set role [second [fifth $r]]
      set name [second [first $r]]
      if {$type == "spectrum" && $role == "singles"} then {lappend ll $name}
   }
   return $ll
}

proc make-resource-menu {} {
    global frame resources
    upvar #0 $frame-type frametype
# ...read roles of attached spectrum servers for choice-stack widget
    if {$frametype == "hist"} then {
        set resources [make-hist-resource-list]
    } elseif {$frametype == "singles"} then {
        set resources [make-singles-resource-list]
    } else {
        set resources [make-spec-resource-list]
    } 
}

proc set-selections {} {
    global frame
    upvar #0 $frame-selection selection
    set p [string range $frame 1 end]
    foreach i $selection {:modify [set p]LIST :select $i}
}

proc mksb {} {
   global env frame frametype rowsize rowoverhead
   global resources optionsmenu analysismenu showingmenu patternmenu msfmenu msf selectmode
   upvar #0 [set frametype]-ACTIONs actionmenu

  set rows 15
  set cols 70

   :set footer_position center
   :frame [self frame-name]  :label "[self frame-title]" :show-footer T :toplevel T  \
        :icon-image "@$env(ICONHOME)/spectrum"  \
        :icon-name [self icon-title]

   set p [string range $frame 1 end]

   wm protocol [self frame-name]  WM_DELETE_WINDOW  "click-quit [self frame-name]"

   :panel T1 :layout V
   :layout H
    make-resource-menu
   :menubutton [set p]RESOURCEMENU :label Resource :menu $resources
   :text [set p]RESOURCE :label "" :w 10
   :hskip 10
   :text [set p]DIRECTORY :label Directory :w 30 :shifters T
   :hskip 5
   :button [set p]UP      :label "@$env(ICONHOME)/uparrow"    :command click-up
   :button [set p]DOWN    :label "@$env(ICONHOME)/downarrow"  :command "click-down 0"
   :hskip 10
   :checkbox [set p]TICK  :label ""

   :panel T2 :layout V
   :layout H
   :menubutton [set p]PATTERNMENU :label Selection :menu $patternmenu
   :text [set p]PATTERN :label "" :w 25
   :col-gap 5
   :menubutton [set p]MSF :label [lindex $msfmenu $msf] :strings $msfmenu :w 15
   :button [set p]REDISPLAY :label Redisplay :command click-redisplay
   :button HELP
   :button [set p]CLONE     :label Clone :command click-another

   :panel T3 :layout V
   :list [set p]LIST  :rows $rows :cols $cols :select $selectmode  :double-click T
   bind [:path [set p]LIST].list <ButtonRelease-2> "click-show 0"
   bind [:path [set p]LIST].list <ButtonRelease-3> "click-show 1"

   :panel B :layout B :after FOOTER
   :layout H
   :menubutton [set p]SHOWING :label Show :menu $showingmenu
   :col-gap 5
   :button [set p]PREVIOUS  :command "click-show-next -1"  :label "@$env(ICONHOME)/uparrow"
   :button [set p]NEXT      :command "click-show-next 1"   :label "@$env(ICONHOME)/downarrow"
   :button [set p]STEPUP    :command "click-show-step -1"  :label "@$env(ICONHOME)/times2"
   :button [set p]STEPDOWN  :command "click-show-step 1"   :label "@$env(ICONHOME)/divide2"
   :button [set p]SELECT    :label "Select all"   :command "click-select all"
   :button [set p]DESELECT  :label "Deselect all" :command "click-select none"
   :menubutton [set p]OPTIONS  :label Options  :menu $optionsmenu
   :menubutton [set p]ANALYSIS :label Analysis :menu $analysismenu
   :menubutton [set p]ACTION   :label Actions  :strings $actionmenu :rows 15

    centre-frame [self frame-name]
    open-frame [self frame-name]
    :galley_size [set p]LIST  $rows $cols
}

#    procedure called on Configure event
proc click-configure {w} {
   :galley_resize [string range $w 1 end]LIST
#   set-selections
}

proc click arg {
   global debug frame
   if {$debug} then {puts stderr "click with argument \{$arg\}"}
# insert-debug "click entered with argument \{$arg\}"
   set f [lindex $arg 0]
   set c [lindex $arg 1]
   set w [lindex $arg 2]
   set v [lindex $arg 3]

   set f  .[string tolower [string range $w 0 2]]
   set p [string range $f 1 end]

   if {$f != $frame} then {click-tick $f}
   if {$c==":quit"} then {click-quit $f; return}

   clear-footer

   switch -glob $w {
        *TICK           {click-tick $f}
        *RESOURCEMENU   -
        *RESOURCE       {click-resource $v}
        *DIRECTORY      {click-directory $v}
        *PATTERNMENU    -
        *PATTERN        {click-pattern $v}
        *MSF            {click-msf $v}
        *LIST           {click-list [lindex $arg 4]}
        *OPTIONS        {
           switch $v {
              names       {click-details 0}
              details     {click-details 1}
              numeric     -
              unsorted    -
              alphabetic  {click-sorttype $v}
           }
        }
        *ANALYSIS       {click-analysis $v}
        *SHOWING        {
           switch $v {
              {show and deselect}   {click-show 1}
              {just show}           {click-show 0}
           }
        }
        *ACTION      {
           switch $v {
              {zero and deselect}   {click-zero 0}
              {just zero}           {click-zero 1}
              {"just zero"}         {click-zero 1}
              {delete}              {click-delete}
              
              {add/change title}         {click-title}
              {save titles}              {click-savetitles}
              {apply titles}             {click-applytitles}

              {append msf suffix}   {click-append-msf-suffix}
              {remove msf suffix}   {click-remove-msf-suffix}

              {default}             {if {$v != ""} {click-$v}}
           }
        }
        default      {puts stdout $arg}
   }
}


proc double-click arg {
   global debug frame
   upvar #0 $frame-selection selection
   upvar #0 $frame-selection_last selection_last

   if {$debug} then {puts stderr "double-click with argument \{$arg\}"}
# insert-debug "double-click entered with argument \{$arg\}"
   set f [lindex $arg 0]
   set w [lindex $arg 2]
   set v [lindex $arg 3]

   switch -glob $w {
        *LIST  {
            if {[llength $selection_last] > [llength $selection]} then {set selection $selection_last}
            click-down 1
        }
        default      {puts stdout $arg}
   }
}

proc click-import args {inform idb start}
proc click-export args {inform exp start}

proc click-analysis v {

   switch -glob $v {
     {projecting}                 {call-analysis cut start}
     {stretching}                 {call-analysis str start}
     {adding-up}                  {call-analysis add start}
     {exporting}                  {inform exp start}
     {importing}                  {inform idb start}
     {maximum channel counts}     {call-analysis sd click-max-counts}
     {range maximum}              {call-analysis sd click-range-max}
     {total counts}               {call-analysis sd click-total-counts}
     {range counts}               {call-analysis sd click-range-counts}
     {peakfit options...}         {inform opt start BP}
     {peakfind options...}        {inform opt start PF}
     {gainmatch options...}       {inform opt start GM}
     {create NEO++ calibration files}   {inform sd make_NEOgainmatch_file}
     {create EB calibration files}      {inform sd make_EBgainmatch_file}
     {plot options...}            {inform opt start SP}
     {Co60 peak/total}            {call-analysis sd click-Co60-peak-to-total}
     {calibrate}                  {call-analysis cal click-calibrate}
     {save calibrations}          {click-savecalibrations}
     {apply calibrations}         {click-applycalibrations}
     {Eu152 auto-calibration}     {call-analysis sd click-Eu152-auto-calibration}
     {Co60 auto-calibration}      {call-analysis sd click-Co60-auto-calibration}
     {auto-calibration options...}  {inform opt start AC}
     default      {call-analysis sd click-$v}
   }
}

proc compare-numeric {a b} {
   global debug
   if {$debug} then {puts stdout "{$a} {$b}"}
   set pat "(\[^0-9\]+)(\[0-9\]+)(.*)(\.*)"
   set za [regexp $pat $a a0 a1 a2 a3 a4]
   set zb [regexp $pat $b b0 b1 b2 b3 b4]
   if {$za==0 || $zb==0} then {return [string compare $a $b]}
   if {"$a"!="$a0" || "$b"!="$b0"} then {return [string compare $a $b]}
   set z [string compare $a1 $b1]
   if {$z!=0} then {return $z}
   set z [expr int($a2.0-$b2.0)]
   if {$z!=0} then {return $z}
   return [string compare $a $b]
}

proc sort-filelist {path} {
   global frame
   global filelist
   upvar #0 $frame-sorttype sorttype
   set ll {}
#   foreach f $filelist {lappend ll [second $f]\\[first $f]}
   foreach f $filelist {
      if {[catch {lappend ll [second $f]\\[first $f]} m]} {
         display-error-report self "Cannot handle name in directory: $path\n" "Skipping item: $f\n"
      }
   }
   if {"$sorttype"=="numeric"} then \
      {set ll [lsort -dictionary $ll]} \
   elseif {"$sorttype"=="alphabetic"} then \
      {set ll [lsort -ascii $ll]}
   set filelist {}
   foreach f $ll {
      set s [split $f "\\"]
      lappend filelist [list [second $s] [first $s]]
   }
   set l [llength $filelist]
   if {[last $filelist] == "1 Stat"} {
       set filelist [linsert $filelist 0 {1 Stat}]
       set filelist [lreplace $filelist end end]
   }
   if {[last $filelist] == "1 Rate"} {
       set filelist [linsert $filelist 0 {1 Rate}]
       set filelist [lreplace $filelist end end]
   }
}

proc spec-type t {
   if {$t==1} then {return s}
   if {$t==2} then {return d}
   if {$t==3} then {return "-"}
   return ?
}

proc member {n ns} {return [expr [lsearch -exact $ns $n]>=0]}

proc init-sb-frame {} {
   global frame resource directory details sorttype msf
   global $frame-dir $frame-res $frame-pattern $frame-msf
   global $frame-details $frame-sorttype $frame-selection $frame-selection_last $frame-current $frame-dirlist
   set $frame-dirlist {}
   set $frame-pattern ""
   set $frame-selection ""
   set $frame-selection_last ""
   set $frame-current -1
   set $frame-details $details
   set $frame-sorttype $sorttype
   set $frame-dir $directory
   set $frame-res $resource
   set $frame-msf $msf
   mksb
}

proc bring-to-front {f t} {
    upvar #0 $f-type type
    set ft $type
    if {$t == "current"} then {set ft current}
    if {$ft == $t} then {open-frame $f}
}

proc bring-each-to-front {t} {
   global frames
   foreach f $frames {
       upvar #0 $f-type type
       set ft $type
       if {$ft == $t} then {bring-to-front $f $t}
   }
}

proc make-details s {
   global frame directory
   set path [get-directory]
   if {$path == ""} then {set spec $s} else {set spec $path/$s}
   set z [catch {
      set info [eg "(spectrum :name '$spec' ?spec)"]
      set title [eg "(spectrum :name '$spec' ?title)"]
      } m]
   if {$z!=0} then {
      display-eg-error-report self $m "Attempting to read spectrum" $spec
      clear-footer
   }
   set dim [first $info]
   set bases [second $info]
   set ranges [third $info]
   set ll ""
   if {$dim>=1} then {append ll "[first $bases]:[first $ranges]"}
   if {$dim>=2} then {append ll "x[second $bases]:[second $ranges]"}
   if {$dim>2} then {append ll "x..."}
   return [format "%-12s %-40s" $ll $title]
}

proc match-pattern {p} {
   global filelist
   set ll {}
   foreach f $filelist {if {[string match $p [second $f]]} then {lappend ll $f}}
   return $ll
}

proc xxxclick-up {} {
   global frame directory resource
   upvar #0 $frame-selection selection
   set i [string last / $directory]
   if {$resource == "sort"} {set i -1}
   if {$i<0} then {set directory ""}
   if {$i==0} then {set directory "/"}
   if {$i>0} then {set directory [string range $directory 0 [expr $i-1]]}
   set selection {}
   click-redisplay
}


proc read-directory {} {
   global frame
   global resource directory dircount filelist env preferences
   upvar #0 $frame-pattern pattern
   upvar #0 $frame-msf msf
   set path [get-directory]

   set preferences(directory.$resource) $directory

   if {$resource == "" && $msf != 0} then {
      set z [catch {eg "(directory :path '$path' ?names)"} m]
      if {$z!=0} then {
         if {$m == 0x30004} then {
            set-footer "Error $m attempting to read directory $path - perhaps it has been deleted"
            after 1000; after 1 click-up
         } else {
            display-eg-error-report self $m "Attempting to read directory" $path
         }
         return 0
      }
      set ll [lsort [strip-dots $m]]
      set m {}

      if {$msf==1} then {
         if {$pattern == ""} then {
            foreach f $ll {
               if {[file isdirectory [file join $path $f]]} then {
                  lappend m "2 $f"
               } else {
                  set s [last [split $f .]]
                  if {$s == "msf" || $s == "MSF"} then {
                     lappend m "1 $f"
                  }
               }
            }
         } else {
            foreach f $ll {
               if {[file isdirectory [file join $path $f]]} then {
                  lappend m "2 $f"
               } else {
                  set s [last [split $f .]]
                  if {$s == "msf" || $s == "MSF"} then {
                     if {[string match [set pattern]* $f]} then {lappend m "1 $f"}
                  }
               }
            }
         }
      } else {
         if {$pattern == ""} then {
            foreach f $ll {lappend m "3 $f"}
         } else {
            foreach f $ll {
               if {[string match [set pattern]* $f]} then {lappend m "3 $f"}
            }
         }
      }
      set filelist $m
   } else {
#       if {"$pattern" != "" && $resource != "softhist"} then {};#
       if {"$pattern" != ""} then {
           if {"$path" != ""} then {
               if {$resource != ""} then {
                   set path $path/$pattern
               } else {
                   set path [file join $path $pattern]
               }
           } else {
               set path $pattern
           }
       }
       set z [catch {eg "(spectrum :path '$path' ?names)"} m]
       if {$z!=0} then {
         if {$m == 0x30004 || $m == 0x30008} then {
            set-footer "Error $m attempting to read directory $path - perhaps it has been deleted"
            if {$resource != "hist" && $resource != "singles"} then {
               after 1000; after 1 click-up
            } else {
               display-eg-error-report self $m "Attempting to read directory" $path
            }
         } else {
            display-eg-error-report self $m "Attempting to read directory" $path
         }
         clear-footer
         return 0
       }
       set filelist $m
#       if {"$pattern" != "" && $resource == "softhist"} {set filelist [match-pattern $pattern]}
       if {"$pattern" != ""} {set filelist [match-pattern $pattern]}
       sort-filelist $path
   }
   make-dirlist $frame
   return 1
}

proc click-append-msf-suffix {} {
   global frame
   upvar #0 $frame-pattern pattern

      frame-busy
      set-footer "Obtaining list of spectra"
#    obtain directory contents
       set path [get-directory]
       set z [catch {eg "(directory :path '$path' ?files)"} m]
       if {$z!=0} then {
         display-eg-error-report self $m "Attempting to read directory" $path
         clear-footer
         return
       }
#    obtain list of names
       set ll [strip-dots [make-list $m]]
#    extract list of simple files without msf suffix
       set m {}
       foreach f $ll {
           if {![file isdirectory [file join $path $f]]} then {
               set s [last [split $f .]]
               if {$s != "msf" && $s != "MSF"} then {lappend m "$f"}
           }
       }
#    apply pattern selection
       if {"$pattern" != ""} then {
          set filelist {}
          foreach f $m {if {[string match $pattern $f]} then {lappend filelist $f}}
       } else {
          set filelist $m
       }
#    add msf suffix to selected files
      set-footer "Adding msf file suffix"
       foreach f $filelist {
          set z [catch {file rename [file join $path $f] [file join $path $f.msf]} m]
          if {$z!=0} then {
              display-eg-error-report self $m "Attempting to rename file" [file join $path $f]
          }
       }
      frame-idle
      clear-footer
      click-redisplay
}

proc click-remove-msf-suffix {} {
   global frame
   upvar #0 $frame-pattern pattern

      frame-busy
      set-footer "Obtaining list of spectra"
#    obtain directory contents
       set path [get-directory]
       set z [catch {eg "(directory :path '$path' ?files)"} m]
       if {$z!=0} then {
         display-eg-error-report self $m "Attempting to read directory" $path
         clear-footer
         return
       }
#    obtain list of names
       set ll [strip-dots [make-list $m]]
#    extract list of simple files with msf suffix
       set m {}
       foreach f $ll {
           if {![file isdirectory [file join $path $f]]} then {
               set s [last [split $f .]]
               if {$s == "msf" || $s == "MSF"} then {lappend m "$f"}
           }
       }
#    apply pattern selection
       if {"$pattern" != ""} then {
          set filelist {}
          foreach f $m {if {[string match $pattern $f]} then {lappend filelist $f}}
       } else {
          set filelist $m
       }
#    remove msf suffix from selected files
      set-footer "Removing msf file suffix"
       foreach f $filelist {
          set f1 [string range $f 0 [expr [string length $f] - 5]]
          set z [catch {file rename [file join $path $f] [file join $path $f1]} m]
          if {$z!=0} then {
              display-eg-error-report self $m "Attempting to rename file" [file join $path $f]
          }
       }
      frame-idle
      clear-footer
      click-redisplay
}

proc make-simple-dir-line {t s} {
   global frame
   if {$s=="." || $s==".."} then {return ""}
   if {[string index $s 0]=="."} then {return ""}
   return [format "%s %16s" [spec-type $t] $s]
}

proc make-dir-line {t s} {
   global frame
   upvar #0 $frame-details details
   if {$s=="." || $s==".."} then {return ""}
    if {[string index $s 0]=="."} then {return ""}
   if {$t==2 || $t==3} then {return [format "%s %16s" [spec-type $t] $s]}
   if {$t==1} then {
      if {$details} then {return [format "%s %16s  %s" \
            [spec-type $t] $s [make-details $s]] } \
      else {return [format "%s %16s" [spec-type $t] $s]}
   }
   return ""
}

proc make-title-line {s} {

   if {$s=="." || $s==".."} then {return ""}
   if {[string index $s 0]=="."} then {return ""}
   
   set path [get-directory]
   if {$path == ""} then {set spec $s} else {set spec $path/$s}
   set z [catch {set title [eg "(spectrum :name '$spec' ?title)"]} m]
   if {$z!=0} then {
      display-eg-error-report self $m "Attempting to read spectrum" $spec
      clear-footer
   }

   if {$z != 0 || $title == ""} then {return ""}
   
   return "$s  $title"
}

proc make-calibration-line {s} {

   if {$s=="." || $s==".."} then {return ""}
   if {[string index $s 0]=="."} then {return ""}
   
   set path [get-directory]
   if {$path == ""} then {set spec $s} else {set spec $path/$s}

   set z [catch {set info [eg "(spectrum :name '$spec' ?spec)"]} m]
   if {$z != 0} then {
      display-eg-error-report self $m "Attempting to read spectrum" $spec
      clear-footer
      return ""
   }

   set dim [first $info]
   set calibration {}
   for {set i 1} {$i <= $dim} {incr i} {

       set z [catch {set cal [eg "(spectrum :name '$spec' :dim $i ?cal)"]} m]
       if {$z!=0} then {
           display-eg-error-report self $m "Attempting to read spectrum" $spec
           clear-footer
       } else {
           if {$cal != ""} {lappend calibration $i $cal}
       }
   }

   if {[llength $calibration] == 0} then {return ""}

   return "$s $calibration"
}

proc click-savetitles {}  {
   global frame
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist spectra

   global information

     if {$selection == ""} {set-footer "Warning:- no spectra selected"; return}

      set information {}
      foreach p $selection {
         set spectrum [lindex $spectra $p]
         if {[first $spectrum] != "s"} {continue}
         set l [make-title-line [second $spectrum]]
         if {$l!= ""} then {lappend information $l}
      }
      
      midas-browser W do-saveinformation
}

proc click-savecalibrations {}  {
   global frame
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist spectra

   global information

     if {$selection == ""} {set-footer "Warning:- no spectra selected"; return}

      set information {}
      foreach p $selection {
         set spectrum [lindex $spectra $p]
         if {[first $spectrum] != "s"} {continue}
         set l [make-calibration-line [second $spectrum]]
         if {$l!= ""} then {lappend information $l}
      }
      
      midas-browser W do-saveinformation
}

proc click-applytitles {} {
    global information

    midas-browser R do-readinformation
    
    set path [get-directory]
    set n 0
    
    foreach item $information {
        if {$item == ""} {continue}
        
        set s [first $item]
        if {$path == ""} then {set spec $s} else {set spec $path/$s}
        set title [tail $item]
        if {$title == ""} {continue}
        
        set z [catch {eg "(spectrum :name '$spec' ?spec)"} m]
        if {$z==0} then {set z [catch {eg "(spectrum :name '$spec' :title '$title')"} m]}
        if {$z!=0} then {insert-log "spectrum $spec not titled - [eg "(sys :error $m ?message)"]"} else {incr n}
    }
    
    click-redisplay
    
    set-footer "$n spectra titled"
}

proc click-applycalibrations {} {
    global information

    midas-browser R do-readinformation
    
    set path [get-directory]
    set n 0
    
    foreach item $information {
        if {$item == ""} {continue}
        
        set s [first $item]
        if {$path == ""} then {set spec $s} else {set spec $path/$s}

        set itemlen [llength $item]

        set dim [lindex $item 1]
        set calibration [lindex $item 2]
        
        set z [catch {eg "(spectrum :name '$spec' ?spec)"} m]
        if {$z==0} then {set z [catch {eg "(spectrum :name '$spec' :dim $dim :cal '$calibration')"} m]}
        if {$z!=0} then {insert-log "spectrum $spec not calibrated - [eg "(sys :error $m ?message)"]"}

        if {[llength $item] > 3} {

            set dim [lindex $item 3]
            set calibration [lindex $item 4]

            if {$z==0} then {set z [catch {eg "(spectrum :name '$spec' :dim $dim :cal '$calibration')"} m]}
            if {$z!=0} then {insert-log "spectrum $spec not calibrated - [eg "(sys :error $m ?message)"]"}
        }
        if {$z==0} {incr n}
    }
    
    click-redisplay
    
    set-footer "$n spectra calibrated"
}

proc do-saveinformation {args} {
   upvar #0 browserdirectory directory
   upvar #0 browserfile file
   global information

   set z [catch {open $directory/$file w} f]
   if {$z != 0} then {midas-warning "Unable to write $directory/$file\n$f"; return}
   foreach item $information {puts $f $item}
   close $f
}

proc do-readinformation {args} {
   upvar #0 browserdirectory directory
   upvar #0 browserfile file
   global information

   set z [catch {open $directory/$file r} f]
   if {$z != 0} then {midas-warning "Unable to read $directory/$file\n$f"; return}
   set information [split [read $f] \n]
   close $f
}

proc make-dirlist f {
   global filelist
   global dircount
   upvar #0 $f-dirlist dirlist
   upvar #0 $f-details details
   set dirlist {}
   set dircount 0
   if {$details} then {
      foreach p $filelist {
         set t [first $p]
         set s [tail $p]
         set l [make-dir-line $t $s]
         if {$l!=""} then {
            lappend dirlist $l
            incr dircount
         }
      }
   } else {
      foreach p $filelist {
         set t [first $p]
         set s [tail $p]
         set l [make-simple-dir-line $t $s]
         if {$l!=""} then {
            lappend dirlist $l
            incr dircount
         }
      }
   }
}

proc paint-directory {} {
   global frame
   global dircount directory resource
   upvar #0 $frame-dirlist dirlist
   upvar #0 $frame-msf msf

   set p [string range $frame 1 end]
   :modify [set p]DIRECTORY :value $directory
   set name spectrum
   if {$resource != ""} then {
      :modify [set p]RESOURCE  :value $resource      
   } else {
      :modify [set p]RESOURCE  :value "direct"
      if {$msf==2} {set name file}

   }
   :modify [set p]LIST :append F :strings $dirlist :see 0
   set-footer "$dircount [pluralise-word $name $dircount]/[pluralise-word directory $dircount] found"
}

proc change-frame {f} {
   global frame
   global frametype $frame-type
   global directory $frame-dir
   global resource $frame-res
   global details $frame-details
   global sorttype $frame-sorttype
   global msf $frame-msf
   global $f-dir $f-res $f-details $f-sorttype $f-type $f-msf

   set $frame-res $resource
   set $frame-dir $directory
   set $frame-details $details
   set $frame-sorttype $sorttype
   set $frame-msf $msf

   set frame $f
   set frametype [set $frame-type]
   set resource [set $frame-res]
   set directory [set $frame-dir]
   set details [set $frame-details]
   set sorttype [set $frame-sorttype]
   set msf [set $frame-msf]
}

proc click-another {} {
   global frame frametitle frametype
   global directory $frame-dir resource $frame-res $frame-type
   global details $frame-details sorttype $frame-sorttype msf $frame-msf

   change-frame $frame

   set resource  [set $frame-res]
   set directory [set $frame-dir]
   set details   [set $frame-details]
   set sorttype  [set $frame-sorttype]
   set msf       [set $frame-msf]

   set f [new-sb-frame]
   global $f-type
   set $f-type [set $frame-type]
   set frame $f
   set frametype [set $frame-type]
   set t [set frametype]frametitle
   global $t
   set frametitle "[set $t] ($frame)"

   init-sb-frame
   fix-ticks
   click-redisplay
}

proc get-resource {} {
    global resource
    if {$resource==""} then {return ""} else {return "/$resource"}
}

proc get-directory {} {
    global resource directory
    if {$directory==""} then {return [get-resource]}
    if {$resource==""}  then {return $directory}
#    return [file join [get-resource] $directory]
    return [get-resource]/$directory
}

proc get-directory-slash {} {
    set d [get-directory]
    if {$d==""} then {return "$d"} else {return "$d/"}
}

proc click-directory d {
   global frame env
   global directory resource
   upvar #0 $frame-dir dir
   upvar #0 $frame-selection selection

#    reprocess directory supplied to convert any \s in the string
   set directory [midas-convert-filename $d]

   if {$resource == "" && $directory == ""} then {set directory $env(HOME)}
   set dir $directory
   set selection {}
   click-redisplay
}

proc click-pattern {patt} {
   global frame
   upvar #0 $frame-pattern pattern
   upvar #0 $frame-selection selection
   set p [string range $frame 1 end]
   :modify [set p]PATTERN :value $patt
   set pattern $patt
   set selection {}
   click-redisplay
}

proc click-msf {value} {
   global frame preferences msfmenu
   global msf
   upvar #0 $frame-msf gmsf

   :modify [string range $frame 1 end]MSF :label $value
   set msf [lsearch $msfmenu $value]
   set gmsf $msf
   if {$msf==2} {midas-warning "This lists all files whether or not they are spectra."}
   set preferences(directory.usemsf) $msf
   click-redisplay
}

proc click-up {} {
   global frame directory resource
   upvar #0 $frame-selection selection
   set i [string last / $directory]
   if {$resource == "sfm" || $resource == "sort"} {set i -1}
   if {$i<0} then {set directory ""}
   if {$i==0} then {set directory "/"}
   if {$i>0} then {set directory [string range $directory 0 [expr $i-1]]}
   set selection {}
   click-redisplay
}

proc click-down {opt} {
#    opt = 0     just down (called from click on Down button)
#    opt = 1     down if directory or show if spectrum (called by double-click on list )
   global frame directory
   upvar #0 $frame-selection selection
   upvar #0 $frame-selection_last selection_last
   upvar #0 $frame-dirlist dirlist

   if {[llength $selection]==0} then {
      set-footer "no directory/spectrum selected!!!"
      return
   }
   if {$opt == 0} then {
      if {[llength $selection]>1} then {
         set-footer "multiple selections!!!"
         return
      }
   }
   set target [lindex $dirlist [first $selection]]
   set t [string index $target 0]
   if {$t!="d" && $t!="s"} then {
      if {[file isdirectory [file join $directory [second $target]]]} then {
         set t "d"
      } else {
         set t "s"
      }
   }

   if {$t!="d"} then {
      if {$opt == 0} then {set-footer "no directory selected!!!"} \
         else {click-show 1}
      return
   }
   if {[second $target]=="."} then {click-redisplay; return}
   if {[second $target]==".."} then {click-up; return}
   if {$directory == ""} {append directory [second $target]} {
        set directory [string trimright $directory /]
        append directory / [second $target]
   }
   set selection {}
   click-redisplay
}

proc click-resource r {
   global env frame
   global resource directory
   global preferences
   global online-ACTIONs normal-ACTIONs 
   upvar #0 $frame-res res
   upvar #0 $frame-selection selection

   if {$r == "direct"} then {set resource ""} else {set resource $r}
   set res $resource

   if {$resource == ""} then {set directory $env(HOME)} else {set directory ""}

   if {[info exists preferences(directory.$resource)]} then {set directory $preferences(directory.$resource)}

    set p [string range $frame 1 end]

    switch -glob $r {
      SortSas -
      MemSas -
      VMESas -
      sfm -
      sort -
      singles -
      Hist -
      hist* -
      *hist -
      hist     {:modify [set p]ACTION :strings [set online-ACTIONs]}
      default  {:modify [set p]ACTION :strings [set normal-ACTIONs]}
   }

   set p [string range $frame 1 end]
   set selection {}
   click-redisplay
}


#    copy/save; delete and zero are under the Actions menubutton

proc click-save {} {inform speccopy start}
proc click-copy {} {inform speccopy start}

proc click-delete {} {
   global frame
   global resource directory
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist dirlist

   clear-footer
   if {[catch {set selection}] != 0} then {
      set-footer "no spectrum selected!!!"
      return
   }

   frame-busy
   set c 0
   set nc 0
   set z [catch {
       foreach e $selection {
           set target [lindex $dirlist $e]
           set t [string index $target 0]
           if {$t!="d" && $t!="s"} then {
              if {[file isdirectory [file join $directory [second $target]]]} {
                 set t "d"
              } else {
                 set t "s"
              }
           }
           if {$t=="s"} {
             set s [get-directory-slash][second $target]
             set-footer "deleting $s..."
             set z [catch {eg "(spectrum :name '$s' !delete)"} m]
             if {$z!=0} then {incr nc; insert-log "spectrum $s not deleted - [eg "(sys :error $m ?message)"]"} else {incr c}
           } else {error "sorry, can't delete a directory!!!"}
       }
   } m]
   set selection {}
   frame-idle
   click-redisplay
   if {$nc == 0} then {
       set-footer "total of $c spectra deleted"
   } else {
       set-footer "total of $c spectra deleted and $nc spectra NOT deleted - see session log for details"
   }
}

proc click-title {} {
   global frame
   global resource directory
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist dirlist

   clear-footer
   if {[catch {set selection}] != 0} then {
      set-footer "no spectrum selected!!!"
      return
   }
   
   set title [midas-query title]
   if {$title == ""} {return}

   frame-busy
   set c 0
   set nc 0
   set z [catch {
       foreach e $selection {
           set target [lindex $dirlist $e]
           set t [string index $target 0]
           if {$t!="d" && $t!="s"} then {
              if {[file isdirectory [file join $directory [second $target]]]} {
                 set t "d"
              } else {
                 set t "s"
              }
           }
           if {$t=="s"} {
             set s [get-directory-slash][second $target]
             set-footer "titling $s..."
             set z [catch {eg "(spectrum :name '$s' :title '$title')"} m]
             if {$z!=0} then {incr nc; insert-log "spectrum $s not titled - [eg "(sys :error $m ?message)"]"} else {incr c}
           } else {error "sorry, can't title a directory!!!"}
       }
   } m]
   set selection {}
   frame-idle
   click-redisplay
   if {$nc == 0} then {
       set-footer "total of $c spectra titled"
   } else {
       set-footer "total of $c spectra titled and $nc spectra NOT titled - see session log for details"
   }
}

proc click-zero {opt} {
   global debug frame
   global histogrammer
   global resource directory
   global sort_going online_sort
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist dirlist
   upvar #0 $frame-type type

    clear-footer
    switch $type {
        oldsort
        {
            if {$online_sort} then {
                set z [catch {inform sx put-sortrunstatus} m]
            } else {
                set z [catch {inform so put-sortrunstatus} m]
            }
            if {$z==0} {
                if {$m} {
                    set-footer "cannot zero spectra while acquisition is going"
                    return
                }
            }
        }
        default {}
   }
   if {[catch {set selection}] != 0} then {
      set-footer "no spectrum selected!!!"
      return
   }
   frame-busy
   set c 0
   set nc 0
   set z [catch {
       foreach e $selection {
           set target [lindex $dirlist $e]
           set t [string index $target 0]
           if {$t!="d" && $t!="s"} then {
              if {[file isdirectory [file join $directory [second $target]]]} {
                 set t "d"
              } else {
                 set t "s"
              }
           }
           if {$t=="s"} {
             set s [get-directory-slash][second $target]
             set-footer "zeroing $s..."
             set z [catch {eg "(spectrum :name '$s' !zero)"} m]
             if {$z!=0} then {incr nc; insert-log "spectrum $s not zeroed - [eg "(sys :error $m ?message)"]"} else {incr c}
           } else {error "sorry, can't zero a directory!!!"}
       }
   } m]
   if {$opt == 0} then {click-select none}
   frame-idle
   if {$nc == 0} then {
       set-footer "total of $c spectra zeroed"
   } else {
       set-footer "total of $c spectra zeroed and $nc spectra NOT zeroed - see session log for details"
   }
}

proc click-details {v} {
   global frame
   upvar #0 $frame-details details
   set details $v
   click-redisplay
}

proc click-sorttype {v} {
   global frame
   upvar #0  $frame-sorttype sorttype
   set sorttype $v
   click-redisplay
}

proc click-show {opt} {
   global frame directory
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist dirlist

   if {[llength $selection] == 1} then {
      set target [lindex $dirlist [first $selection]]
      set t [string index $target 0]
      if {$t!="d" && $t!="s"} then {
         if {[file isdirectory [file join $directory [second $target]]]} then {
            set t "d"
         } else {
            set t "s"
         }
      }

      if {$t=="d"} then {
        set-footer "You cannot show a directory - Please select a spectrum"
        return
     }
   }

   call-analysis sd show
   if {$opt != 0} then  {click-select none}
}

proc click-show-next {v} {
    global frame
    global directory
    upvar #0 $frame-selection selection
    upvar #0 $frame-dirlist dirlist
    upvar #0 $frame-current current

    clear-footer
    if {$selection == {}} then {
      set-footer "no spectrum selected!!!"
      return
    }
    set-busy
    set l [llength $selection]
    set current [incr current $v]
    if {$current<0} then {set current [expr $l - 1]}
    if {$current>=$l} then {set current 0}
    set e [lindex $selection $current]
    set spectrumlist [second [lindex $dirlist $e]]
    set m [inform sd show [prefix-list $spectrumlist [get-directory-slash]]]
    set-footer "$m"
    clear-busy
}

proc click-show-step {v} {
    global frame
    global directory
    upvar #0 $frame-selection selection
    upvar #0 $frame-dirlist dirlist

    clear-footer
    if {$selection == {}} then {
      set-footer "no spectrum selected!!!"
      return
    }
    set l [llength $dirlist]
    if {$v > 0} then {
        set current $selection
    } else {
        set current ""
        foreach item $selection {set current "$item $current"}
    }
    set new $current
    click-select "none"
    set j 0
    foreach item $current {
        set i [expr $item + $v]
        while {[lsearch $new $i] >= 0 || [first [lindex $dirlist $i]] != "s"} {
            if {$i<0 || $i>=$l} {break}
            incr i $v
        }
        if {$i<0} then {set i $item}
        if {$i>=$l} then {set i $item}
        set new [lreplace $new $j $j $i]
        incr j
    }
    if {$v < 0} then {
        set current $new
        set new ""
        foreach item $current {set new "$item $new"}
    }
    click-list $new
    click-show 0
    set p [string range $frame 1 end]
    if {$v > 0} then {
        [:path [set p]LIST].list see [last $new]
    } else {
        [:path [set p]LIST].list see [first $new]
    }
}

proc call-analysis {appl funct} {
   global frame
   global  directory
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist dirlist

   clear-footer
   if {$selection=={}} then {set-footer "no spectra selected!!!"; return}
   set-busy
   set spectrumlist {}
   foreach e $selection {lappend spectrumlist [second [lindex $dirlist $e]]}
   set spectrumlist [prefix-list $spectrumlist [get-directory-slash]]
#         this needs to be sorted out   **********************
   if {$funct == "show"} then {
      set m [inform sd show $spectrumlist]
   } else {
      if {$appl == "sd"} then {inform sd start-for-sb}
      set m [inform $appl $funct [list $spectrumlist]]
   }
   set-footer "$m"
   clear-busy
}

proc click-select {opt} {
   global frame
   upvar #0  $frame-selection selection
   set p [string range $frame 1 end]
   if {"$opt" == "all"} then {
      :modify [set p]LIST :select "0 end"
   } else {
      :modify [set p]LIST :select -1
   }
   set selection [[:path [set p]LIST].list curselection]
}

proc click-list {s} {
   global frame debug
   upvar #0 $frame-selection selection
   upvar #0 $frame-dirlist dirlist
   upvar #0 $frame-current current
   upvar #0 $frame-selection_last selection_last

   set selection_last $selection
   set p [string range $frame 1 end]
   set selection $s
    set dd 0
    set ss 0
    foreach e $selection {
        if {[first [lindex $dirlist $e]]=="d"} then {incr dd}
        if {[first [lindex $dirlist $e]]=="s"} then {set ss 1}
    }
    if {$dd >1 || $dd && $ss} then {
        foreach e $selection {
            if {[first [lindex $dirlist $e]]=="d"} then {
                :modify [set p]LIST :deselect $e
            }
        }
        set selection [[:path [set p]LIST].list curselection]

    }
   set current -1
   return
}

proc fix-ticks {} {
   global frame frames
   foreach f $frames {
      set p [string range $f 1 end]
      if {$f==$frame} then {set vl 1} else {set vl 0}
      catch {:modify [set p]TICK :value $vl}
   }
#   bring-to-front $frame current
}

proc click-tick v {
   change-frame $v
   fix-ticks
}

proc click-redisplay {} {
   global directory resource preferences
   set-footer "Scanning directory $directory..."
   set preferences(directory.$resource) $directory
   frame-busy
   if {[read-directory]} then {paint-directory}
   frame-idle
}

proc new-sb-frame {} {
   global frames
   set i 0
   while {[lsearch $frames .sb$i]>=0} {incr i}
   lappend frames .sb$i
   return .sb$i
}

proc delete-sb-frame f {
   global frames
   set i [lsearch $frames $f]
   set frames [lreplace $frames $i $i]
}

proc start     {} {commonstart normal 0}
proc sortstart {mode} {commonstart sort $mode}
proc histstart {} {commonstart hist 0}
proc singlesstart {} {commonstart singles 0}

proc extract-resname {s} {
   if {[string index $s 0] == "/"} then {
      set r [second [split $s / ]]
   } else {
      if {$s == "direct"} then {set r ""} else {set r $s}
   }
}

proc sfmstart {args} {
   if {[llength $args] == 0} {set r 0} {set r [extract-resname [first $args]]}
   commonstart sfm $r
#   click-resource [extract-resname [first $args]]
}

proc commonstart {ft mode}  {
   global debug env started preferences msf selectmode
   global frame frametitle icontitle directory resource
   global frametype online_sort
   global online-ACTIONs normal-ACTIONs
   set frametype $ft

   if {$started == 0} then {
      set started 1
      midas_default_frame
   }

   upvar #0 [set frametype]started started

   if {$started == 0} then {

      catch {wm withdraw .}
      set f [new-sb-frame]
      set frame $f
      global $frame-type
      set $frame-type $frametype
      set t [set frametype]frametitle
      global $t
      set frametitle "[set $t] ($frame)"
      set online_sort $mode

      switch -glob $frametype {
         SortSas  {set icontitle "SortSasBrowser"}
         MemSas   {set icontitle "MemSasBrowser"}
         VMESas   {set icontitle "VMESasBrowser"}
         sfm      {set icontitle "SortBrowser"}
         sort     {set icontitle "SortBrowser"}
         hist*  -
         *hist  -
         hist     {set icontitle "HistBrowser"}
         singles  {set icontitle "SingBrowser"}
         default  {set icontitle "DirBrowser"}
      }

      switch -glob $frametype {
         SortSas -
         MemSas -
         VMESas -
         sfm -
         sort -
         singles -
         hist* -
         *hist -
         hist     {global [set frametype]-ACTIONs; set [set frametype]-ACTIONs [set online-ACTIONs]}
         default  {global normal-ACTIONs; set normal-ACTIONs [set normal-ACTIONs]}
      }

      load_preferences
      set msf $preferences(directory.usemsf)
      set selectmode $preferences(directory.selectmode)

      set directory ""
      if {$frametype == "hist"} then {
         if {[info exists env(HwreHistServer)] == 0} then {set resource hist}  \
            else {set resource $env(HwreHistServer)}
      } elseif {$frametype == "sfm"} then {
         if {[info exists env(SfmSpecServer)] == 0} then {set resource sfm}  \
            else {set resource $env(SfmSpecServer)}
         if {$mode != "0"} then {set resource $mode}
      } elseif {$frametype == "sort"} then {
         if {[info exists env(SortSpecServer)] == 0} then {set resource sort}  \
            else {set resource $env(SortSpecServer)}
      } elseif {$frametype == "singles"} then {
         if {[info exists env(SinglesServer)] == 0} then {set resource singles}  \
            else {set resource $env(SinglesServer)}
      } elseif {$frametype == "normal"} then {
         if {[info exists env(SPECTRUMSRV)] != 0} then {set resource $env(SPECTRUMSRV)}  \
            else {set resource [get-eg-option default-browser-resource]}
         if {$resource == "hist" || $resource == "sort" || $resource == "singles"} then {set resource ""}
         if {$resource == ""} then {set directory $env(HOME)}
      }
      if {[info exists preferences(directory.$resource)]} then {set directory $preferences(directory.$resource)}

      init-sb-frame
      fix-ticks
      set started 1
      click-redisplay
   } else {
       if {$frametype == "sfm" && $mode != "0"} then {
         if {$resource != $mode} {click-resource $mode}
       }
       bring-each-to-front $frametype
       bring-to-front $frame $frametype
   }
}

proc click-quit f {
   global frame frames
   change-frame $f
   upvar #0 $frame-type frametype
   upvar #0 [set frametype]started started
   if {![member $f $frames]} then {destroy-frame $f; break}
   destroy-frame $f
   delete-sb-frame $f
   set started 0
   if {[llength $frames]>0} then {set f [first $frames]; click-tick $f}
}

proc finish args {
   global frames
   foreach f $frames {click-quit $f}
}

proc redisplay-if-showing {d} {
   global debug frame frames
   if {$frames=={}} then {
      if {$debug} then {
         puts stdout "No spectrum browser frames - not calling redisplay"
      }
      return
   }
   if {$debug} then {
      puts stdout "Checking for directory: $d"
   }
   set fr $frame
   foreach f $frames {
      upvar #0 $f-dir dir
      if {$debug} then {
         puts stdout "Checking frame: $f, current directory is: $dir"
      }
      change-frame $f
      if {"$d"=="[get-directory]"} then {
         if {$debug} then {
            puts stdout "Directory found for frame: $f"
         }
         click-redisplay
      }
   }
   change-frame $fr
}

