# Cuts and Projections

# Mon Sep 26 12:59:10 BST 1994, DB/SCL
# (version copied for tk conversion)

package require ServerAccess 2.0
package require SpectrumClient

set started 0

set frame  CUT
set frametitle "Cuts and Projections"
set icontitle "CutProj"

set spectrum ""
set directory ""
set autoshow 0
set subtract 0
set peaklow 0
set peakhigh 0
set backlow 0
set backhigh 0
set directionx 1
set directiony 0

set direction "x"
set resultname ""
set resultdirectory ""

proc repaint {} {
   global spectrum directory 
   global autoshow peaklow peakhigh backlow backhigh subtract
   :modify SPECTRUM  :value $spectrum
   :modify DIRECTORY :value $directory
   :modify AUTOSHOW  :value $autoshow
   :modify PEAKLOW   :value $peaklow
   :modify PEAKHIGH  :value $peakhigh
   if {$subtract == 0} then {set opt T} else {set opt F}
   :modify BACKLOW   :inactive $opt :value $backlow   
   :modify BACKHIGH  :inactive $opt :value $backhigh
}

proc confirm-action {s} {
   set m "Spectrum $s already exists\nPlease confirm that you want to overwrite it"
   return [midas-confirmation $m]
}

proc last-n {p n} {
   set i [expr [llength $p]-$n]
   lrange $p $i end
}

proc map {fun ps} {
   set ll {}
   foreach p $ps {lappend ll [$fun $p]}
   return $ll
}

proc file-front {n} {
   return [join [front [split $n "/"]] "/"]
}

proc file-last {n} {
   return [last [split $n "/"]]
}

proc do-project {} {
   global env debug spectrum directory resultdirectory resultname
   global direction autoshow env
   set d $direction
   set D [uppercase $d]
   clear-footer
   if {"$spectrum" == ""} then {
      set-footer "You haven't selected a spectrum yet!!!"
      return
   }
   if {"$directory" == ""} then {set resultdirectory [file-front $spectrum]} \
          else {set resultdirectory $directory}
   set resultname "[file-last $spectrum]-$d-projection"
   set z [catch {eg "(spectrum :name '[file join $resultdirectory $resultname]' ?spec)"} m]
   if {$z==0} then {
       if {[confirm-action [file join $resultdirectory $resultname]] == 0} then {
          set-footer "action cancelled"
          return
       }
   }
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   set-footer "Projecting $spectrum. This may take some seconds..."
   frame-busy
   catch {:file delete [file join $env(MIDASTempDir) tcl[pid] progress]}

# is spectrum a SOAP path
   set sv [inform ex obtain_SOAPService_byName $spectrum]
   if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
     set ns [join [tail [split $spectrum /]] _]
     set ts [file join [pwd] $ns]
     catch {eg "(spectrum :path '$ts' !delete)"}
     catch {eval exec copy-soap-spectrum $spectrum $ts} m
   } else {
     set ts $spectrum
   }

   set resultspect [file join $resultdirectory $resultname]
# seems to be a feature of windows.
# can't modify/delete file except from with sas(direct).
# Probably because the ?spec call above mmapped it but didn't close the mapping.
# So only the eg library that has it mapped can delete it.
# Maybe best to use eg to delete it anyway in all OSes
   set z [catch {eg "(spectrum :name '$resultspect' !delete)"} m]

# is result spectrum a SOAP path
   set rsv [inform ex obtain_SOAPService_byName $resultspect]
   if {$rsv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
     set ns [join [tail [split $resultspect /]] _]
     set trs [file join [pwd] $ns]
     catch {eg "(spectrum :path '$trs' !delete)"}
   } else {
     set trs $resultspect
   }

   set z [catch {exec specproj -$d  -result $trs \
      -spectrum $ts -progress [file join $env(MIDASTempDir) tcl[pid] progress] } m]
   catch {:file delete [file join $env(MIDASTempDir) tcl[pid] progress]}
   if {$sv != ""} {
     catch {eg "(spectrum :path '$ts' !delete)"}
   }
   if {$rsv != ""} {
     set y [catch {eval exec copy-soap-spectrum $trs $resultspect} x]
     catch {eg "(spectrum :path '$trs' !delete)"}
   }
   frame-idle
   if {$z != 0} then {set-footer $m; return}
   if {"$m" != ""} then {set-footer $m; return} 
   set-footer "Total $D-projection $resultspect created"
   send sb "redisplay-if-showing $resultdirectory"
   if {$autoshow} then {inform sd show [file join $resultdirectory $resultname]}
}

proc do-slice {} {
   global debug spectrum directory resultdirectory resultname subtract autoshow
   global peaklow peakhigh backlow backhigh
   global direction autoshow
   set d $direction
   set slicedir x
   if {$d=="x"} then {set slicedir y}
   set D [uppercase $slicedir]

   clear-footer
   if {"$spectrum" == ""} then {
      set-footer "You haven't selected a spectrum yet!!!"
      return
   }
   if {"$directory" == ""} then {set resultdirectory [file-front $spectrum]} \
      else {set resultdirectory $directory}
   set resultname "[file-last $spectrum].$slicedir=$peaklow-$peakhigh"
   set z [catch {eg "(spectrum :name '[file join $resultdirectory $resultname]' ?spec)"}]
   if {$z==0} then {
       if {[confirm-action [file join $resultdirectory $resultname]] == 0} then {
          set-footer "action cancelled"
          return
       }
   }
#    check for and if necessary create a temporary directory
   if {[midas-check-for-temp] == 0} {return}

   if {!$subtract} then \
      {set limits [lsort -integer [list $peaklow $peakhigh]]} \
   else {set limits [concat [lsort -integer [list $peaklow $peakhigh]] \
                            [lsort -integer [list $backlow $backhigh]]]}
   set-footer "Slicing $spectrum. This may take some seconds..."
   frame-busy


# is spectrum a SOAP path
   set sv [inform ex obtain_SOAPService_byName $spectrum]
   if {$sv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
     set ns [join [tail [split $spectrum /]] _]
     set ts [file join [pwd] $ns]
     catch {eg "(spectrum :path '$ts' !delete)"}
     catch {eval exec copy-soap-spectrum $spectrum $ts} m
   } else {
     set ts $spectrum
   }

   set resultspect [file join $resultdirectory $resultname]
# seems to be a feature of windows.
# can't modify/delete file except from with sas(direct).
# Probably because the ?spec call above mmapped it but didn't close the mapping.
# So only the eg library that has it mapped can delete it.
# Maybe best to use eg to delete it anyway in all OSes
   set z [catch {eg "(spectrum :name '$resultspect' !delete)"} m]

# is result spectrum a SOAP path
   set rsv [inform ex obtain_SOAPService_byName $resultspect]
   if {$rsv != ""} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
     set ns [join [tail [split $resultspect /]] _]
     set trs [file join [pwd] $ns]
     catch {eg "(spectrum :path '$trs' !delete)"}
   } else {
     set trs $resultspect
   }

#   set z [catch {eval exec specslice -result \{[file join $resultdirectory $resultname]\} \
#      -spectrum $spectrum -$slicedir -limit $limits } m]

   set z [catch {eval exec specslice -result \{$trs\} \
      -spectrum $ts -$slicedir -limit $limits } m]

   if {$sv != ""} {
     catch {eg "(spectrum :path '$ts' !delete)"}
   }
   if {$rsv != ""} {
     set y [catch {eval exec copy-soap-spectrum $trs $resultspect} x]
     catch {eg "(spectrum :path '$trs' !delete)"}
   }

   frame-idle
   if {$z != 0} then {set-footer $m; return}
   if {"$m" != ""} then {set-footer $m; return} 
   set-footer "$D-slice (onto $d axis) [file join $resultdirectory $resultname] created"
   send sb "redisplay-if-showing $resultdirectory"
   if {$autoshow} then {inform sd show [file join $resultdirectory $resultname]}
}

proc grab-coords {ts} {
   global debug subtract 
   global peaklow peakhigh backlow backhigh

   if {[llength $ts] == 0} then {
      set-footer "you haven't set any tags at all!!!"
      return
   }
   if {[llength [first $ts]] == 2} then {
      set ts [map first $ts]
   }
   if {$subtract} then {set ts [last-n $ts 4]} else {set ts [last-n $ts 2]}
   if {[llength $ts] > 0} then {set peaklow [lindex $ts 0]}
   if {[llength $ts] > 1} then {set peakhigh [lindex $ts 1]}
   if {[llength $ts] > 2} then {set backlow [lindex $ts 2]}
   if {[llength $ts] > 3} then {set backhigh [lindex $ts 3]}
   repaint
}

proc click-grab-tags {} {
   global direction
   if {"$direction" == "x"} then {grab-coords [inform sd get-all-ytags]}
   if {"$direction" == "y"} then {grab-coords [inform sd get-all-xtags]}
}

proc click-total {} {do-project}

proc click-gated {} {do-slice}

proc click-redisplay {} {
   repaint
   clear-footer
}

proc click-direction d {
   global direction
   if {$d == 0} then {set direction "x"}
   if {$d == 1} then {set direction "y"}
   repaint
}

proc click-default {w v} {
   global spectrum directory subtract autoshow 
   global peaklow peakhigh backlow backhigh 
   set [lowercase $w] $v
   repaint
   clear-footer
}

proc start args {
   global started spectrum
   global peaklow peakhigh backlow backhigh subtract

   if {[llength $args] == 1} then {set args [first $args]}
   if {$started == 0} then {make-frame; set started 1} else {open-frame}  
   if {[llength $args] > 0} then {set spectrum [first $args]}
   set subtract 0
   set peaklow 0; set peakhigh 0; set backlow 0; set backhigh 0
   click-redisplay
}


proc make-frame {} {
   global env

   :frame [self frame-name] :label "[self frame-title]" :show-footer T  \
      :icon-image "@$env(ICONHOME)/spectrum"  \
      :icon-name [self icon-title]

    :panel P1 :layout V :pady 5 :padx 10
     :layout H; :row-gap 5
     :text SPECTRUM   :label "2d spectrum:" :w 36 :valuex 20c
     :next-row T
     :text DIRECTORY  :label "Result directory:" :w 36 :valuex 20c
     :next-row T
     :checkbox AUTOSHOW :label "Show result:" :valuex 20c
     :next-row T
     :number PEAKLOW  :label "Peak Low:"   :w 6 :max 8192  :valuex 20c
     :number PEAKHIGH :label "Peak High:"  :w 6 :max 8192  :valuex 18c
     :next-row T
     :checkbox SUBTRACT :label "Subtract Background" :valuex 20c
     :next-row T
     :number BACKLOW  :label "Background Low:"   :w 6 :max 8192  :valuex 20c  :inactive T
     :number BACKHIGH :label "Background High:"  :w 6 :max 8192  :valuex 18c  :inactive T
     :next-row T
     :choice DIRECTION :label "Projection onto:" :exclusive T :strings [list "X axis" "Y axis"] :valuex 20c

    :panel P3 :layout V :pady 5 :padx 10
     :layout H; :row-gap 10; :col-gap 5
      :button TOTAL :label "Total projection"
      :button GATED :label "Gated projection"
      :button GRAB-TAGS :label "Grab Tags"
      :next-row T
      :button REDISPLAY
      :hskip 100
      :button HELP

  :show T
}

