#  copy, save, export and import spectra

#  Dec 1 1998  (made using speccopy as a start point)

#    common source which supports speccopy (SPECCOPY); import (IDB) and export (EXP)

package require ServerAccess 2.0
package require SpectrumClient

set SOAPSpectrumRoles {Spectrum Hist}

set started 0

set frame [uppercase [Get_My_Name]]

proc do-extension {treatment file} {
   switch -glob [first $treatment] {
      [Kk]eep        {return $file}
      [Aa]dd         {return $file[second $treatment]}
      [Rr]emove      {set fl [split $file .]; if {[llength $fl]!=1} {set fl [join [lreplace [split $file .] end end] .]}; return $fl}
      [Ss]ubstitute  {set fl [split $file .]; if {[llength $fl]!=1} {set fl [join [lreplace [split $file .] end end] .]}; return $fl[second $treatment]}
   }
}

switch $frame {
   SPECCOPY {
     set frametitle "Spectrum Copy & Online Histogram Save"
     set icontitle "SpecCopy"
   }
   IDB {
     set frametitle "Importing Spectra (1d only)"
     set icontitle "Import"
   }
   EXP {
     set frametitle "Exporting Spectra"
     set icontitle "Export"
   }
}


#    source resource variables
switch $frame {
   SPECCOPY {
      set src-resources {hist Hist}
      set src-resource ""
      set src-directory ""
      set src-filelist ""
      set src-dirlist ""
      set src-selection ""
      set defaultsrcresource hist
      set src-sorttypes {"alphabetic" "numeric" "unsorted"}
      set src-sorttype "numeric"
   }
   EXP {
      set src-resources {direct}
      set src-resource ""
      set src-directory ""
      set src-filelist ""
      set src-dirlist ""
      set src-selection ""
      set defaultsrcresource direct
      set src-sorttypes {"alphabetic" "numeric" "unsorted"}
      set src-sorttype "numeric"
   }
   IDB {
      set src-resources {}
      set src-resource ""
      set src-directory ""
      set src-filelist ""
      set src-dirlist ""
      set src-selection ""
      set defaultsrcresource ""
      set src-sorttypes {"alphabetic" "numeric" "unsorted"}
      set src-sorttype "numeric"
   }
}

#    destination resource variables
switch $frame {
   SPECCOPY {
      set destn-resources {direct}
      set destn-resource ""
      set destn-directory ""
      set destn-filelist ""
      set destn-dirlist ""
      set destn-selection ""
      set defaultdestnresource direct
      set destn-sorttypes {"alphabetic" "numeric" "unsorted"}
      set destn-sorttype "numeric"
   }
   EXP {
      set destn-resources ""
      set destn-resource ""
      set destn-directory ""
      set destn-filelist ""
      set destn-dirlist ""
      set destn-selection ""
      set defaultdestnresource ""
      set destn-sorttypes {"alphabetic" "numeric" "unsorted"}
      set destn-sorttype "numeric"
   }
   IDB {
      set destn-resources {direct}
      set destn-resource ""
      set destn-directory ""
      set destn-filelist ""
      set destn-dirlist ""
      set destn-selection ""
      set defaultdestnresource direct
      set destn-sorttypes {"alphabetic" "numeric" "unsorted"}
      set destn-sorttype "numeric"
   }
}

set preferences(direct.directory) $env(HOME)

if {$env(platform) == "windows"} then {
  set spext 1
} else {
  set spext 0
}

set abortflag 0

set selection {}

set savedir ""

set patternmenu {""}
set pattern ""

if {$frame == "EXP"} then {
   set format 0
   set ext 0

   set treatments    [list "Keep existing" "Add .txt" "Remove existing" "Substitute .txt" "Substitute .html"]
   set formats       [list "Ascii Y only (1D)" "Ascii X Y (1D)" "Ascii 5Y (1D)" "By Column (2D)" "By Row (2D)" "To Web"]

   proc click-format args {global format; set format [first $args]}
   proc click-extension args {global ext; set ext [first $args]}

}

if {$frame == "IDB"} then {
   set format 0
   set ext 0
   set option 0

#    option for IDB
#    0  import only
#    1  display only
#    2  import and display

   set treatments    [list "Keep existing" "Add .msf" "Remove existing" "Substitute .msf"]
   set formats       [list "Ascii Y only" "Ascii X Y" "Windows BMP" "Ana" "spe (radware 1d)" "GEC SDB"]
   set idboptionmenu [list "Import Only" "Display Only" "Import and Display"]

   proc click-option args {global option; set option [first $args]}
   proc click-format args {global format; set format [first $args]}
   proc click-extension args {global ext; set ext [first $args]}

}

proc click-abort {args} {global abortflag; set abortflag 1}

#    destination spectrum access
proc make-destn-resource-list {} {
  upvar #0 destn-resources resources

   set z [catch {eg "(experiment ?resources)"} m]
   if {$z==0} then {set rs $m} else {set rs ""}

   set resources {direct}

   set count 0
   foreach r $rs {
      set type [second [fourth $r]]
      set role [second [fifth $r]]
      if {$type == "spectrum" && $role == "disc"} then {
         incr count
         if {[lsearch $resources $role] == -1} then {lappend resources $role}
      }
   }

   if {$count > 1} then {
      foreach r $rs {
#    next scan through resources and add instances of all disc spectrum servers to the list
         set type [second [fourth $r]]
         set role [second [fifth $r]]
         set name [second [first $r]]
         if {$type == "spectrum" && $role == "disc"} then {lappend resources $name}
      }
   }
}

#    source spectrum access

proc make-src-resource-list {} {
  global SOAPSpectrumRoles
  upvar #0 src-resources resources

   set z [catch {eg "(experiment ?resources)"} m]
   if {$z==0} then {set rs $m} else {set rs ""}

   set resources {direct}

#    scan through resources and count instances of all spectrum servers
   set count 0
   foreach r $rs {
      set type [second [fourth $r]]
      set role [second [fifth $r]]
      if {$type == "spectrum"} then {
         incr count
         if {[lsearch $resources $role] == -1} then {lappend resources $role}
      }
   }

   if {$count > 1} then {
#    next scan through resources and add instances of all spectrum servers to the list
      foreach r $rs {
         set type [second [fourth $r]]
         set role [second [fifth $r]]
         set name [second [first $r]]
         if {$type == "spectrum"} then {lappend resources $name}
      }
   }

# add the SOAP list - can't handle access by Role, use Name

   foreach rl $SOAPSpectrumRoles {
      set ss [inform ex obtain_SOAPServers_byRole $rl]
      if {$ss == {}} then {continue}
      foreach s $ss {
#    scan through resources and add instances of all spectrum servers to the list
         set rs [inform ex obtain_SOAPServerInfo $s $rl]
         set name [first $rs]
         if {[lsearch $resources $name] == -1} then {lappend resources $name}
      }

      foreach s $ss {
      }
   }

}

#    SPECCOPY copies between spectrum sources 
#    IDB only has a destination spectrum source
#    EXP only has a source spectrum source
switch $frame {
   SPECCOPY {
   }
   IDB {
     proc make-src-resource-list {} {global src-resources; set src-resources ""}
   }
   EXP {
     proc make-destn-resource-list {} {global destn-resources; set destn-resources ""}
   }
}

proc compare-numeric {a b} {
   set pat "(\[^0-9\]+)(\[0-9\]+)(.*)(\.*)"
   set za [regexp $pat $a a0 a1 a2 a3 a4]
   set zb [regexp $pat $b b0 b1 b2 b3 b4]
   if {$za==0 || $zb==0} then {return [string compare $a $b]}
   if {"$a"!="$a0" || "$b"!="$b0"} then {return [string compare $a $b]}
   set z [string compare $a1 $b1]
   if {$z!=0} then {return $z}
   set z [expr int($a2.0-$b2.0)]
   if {$z!=0} then {return $z}
   return [string compare $a $b]
}

proc sort-filelist {which path} {
   upvar #0 $which-filelist filelist
   upvar #0 $which-sorttype sorttype
   set ll {}
   foreach f $filelist {
      if {[catch {lappend ll [second $f]\\[first $f]} m]} {
         display-error-report self "Cannot handle name in directory: $path\n" "Skipping item: $f\n"
      }
   }
   if {"$sorttype"=="numeric"} then \
      {set ll [lsort -command compare-numeric $ll]} \
   elseif {"$sorttype"=="alphabetic"} then \
      {set ll [lsort -ascii $ll]}
   set filelist {}
   foreach f $ll {
      set s [split $f "\\"]
      lappend filelist [list [second $s] [first $s]]
   }
}

proc get-resource {which} {
    upvar #0 $which-resource resource
    if {$resource == "" || $resource == "direct"} then {return ""} \
       else {return "/$resource"}
}

proc get-directory {which} {
   upvar #0 $which-resource resource
   upvar #0 $which-directory directory

    set r [get-resource $which]
    if {$r == "" } then {return "$directory"}
    if {$directory == ""} then {return $r}
    return [file join $r $directory]
}

proc spec-type t {
   if {$t==1} then {return s}
   if {$t==2} then {return d}
   return ?
}

proc make-dir-line {t s} {
   if {$s=="." || $s==".."} then {return ""}
   if {[string index $s 0]=="."} then {return ""}
   if {$t==1 || $t==2} then {return [format "%s %16s" [spec-type $t] $s]}
   return ""
}

proc make-dirlist {which} {
   upvar #0 $which-filelist filelist
   upvar #0 $which-dirlist dirlist

   set dirlist {}
   foreach p $filelist {
      set t [first $p]
      set s [second $p]
      set l [make-dir-line $t $s]
      if {$l != ""} then {lappend dirlist $l}
   }
}

proc match-pattern {p} {
   upvar #0 src-filelist filelist
   set ll {}
   foreach f $filelist {if {[string match $p [second $f]]} then {lappend ll $f}}
   return $ll
}

proc read-directory {which} {
   upvar #0 $which-resource resource
   upvar #0 $which-directory directory
   upvar #0 $which-filelist filelist
   global pattern frame
   global env

   set path [get-directory $which]

   if {$which == "src"} then {

switch $frame {
   EXP -
   SPECCOPY {
      set z [catch {eg "(spectrum :path '$path' ?names)"} m]
      if {$z!=0} then {
            display-eg-error-report self $m "Attempting to read directory" $path
            clear-footer
      }
      set filelist $m
   }
   IDB {

   switch $env(platform) {
      windows {set m [:directory names :path $path]}
      default {set m [:directory files :path $path]}
   }

      set l {}
      foreach line $m {
         if {[catch {set name [first $line]} m]} {
            display-error-report self "Cannot handle name in directory: $path\n" "Skipping item: $line\n"
            continue
         }
         if {$name == "." || $name == ".."} then continue
         set c [string range [second $line] 0 0]
         if {$c == "-"} then {lappend l [list 1 $name]}
         if {$c == "d"} then {lappend l [list 2 $name]}
      }
      set filelist $l
   }
}

   } else {

switch $frame {
   IDB -
   SPECCOPY {
      set z [catch {eg "(spectrum :path '$path' ?names)"} m]
         if {$z!=0} then {
            display-eg-error-report self $m "Attempting to read directory" $path
            clear-footer
         }
      set filelist $m
   }
   EXP {

   switch $env(platform) {
      windows {set m [:directory names :path $path]}
      default {set m [:directory files :path $path]}
   }

      set l {}
      foreach line $m {
         if {[catch {set name [first $line]} m]} {
            display-error-report self "Cannot handle name in directory: $path\n" "Skipping item: $line\n"
            continue
         }
         if {$name == "." || $name == ".."} then continue
         set c [string range [second $line] 0 0]
#         if {$c == "-"} then {lappend l [list 1 $name]}
         if {$c == "d"} then {lappend l [list 2 $name]}
      }
      set filelist $l
   }
}

   }

   if {$which == "src"} then {
      if {"$pattern" != ""} then {
         set z [catch {match-pattern $pattern} m]
         if {$z!=0} then {
            display-error-report self $m "Attempting to pattern match" $path
            clear-footer
         } else {set filelist $m}
      }
   }
   sort-filelist $which $path
   make-dirlist $which
}

proc paint-directory {which} {
   upvar #0 $which-directory directory
   upvar #0 $which-dirlist dirlist

   if {$which == "src"} then {set W S} else {set W D}
   :modify [set W]DIRECTORY :value $directory
   :modify [set W]LIST :append F :strings $dirlist :see 0
}

proc click-resource {which v} {
    global env
   upvar #0 $which-resource resource
   if {$which == "src"} then {set W S} else {set W D}
   set resource $v
   :modify [set W]RESOURCE :value $resource
   if {$resource == "direct"} then {set directory $env(HOME)} \
      else {set directory ""}
   click-directory $which $directory
}

proc click-sorttype {which v} {
   upvar #0 $which-sorttype sorttype
   if {$which == "src"} then {set W S} else {set W D}
   set sorttype $v
   :modify [set W]RESOURCESORTTYPE :label $sorttype
   read-directory src
   paint-directory src
}

proc click-pattern v {
#    selection pattern applies to source directory only
   global pattern
   upvar #0 src-selection selection

   set pattern $v
   :modify PATTERN :value $pattern
   set selection {}

   read-directory src
   paint-directory src
}

proc click-directory {which d} {
   global preferences
   upvar #0 $which-directory directory
   upvar #0 $which-selection selection
   upvar #0 $which-resource resource

   if {$d != ""} then {set directory [eval file join [file split $d]]} else {set directory ""}
   set selection {}

   set preferences($resource.directory) $directory

   set-busy
   read-directory $which
   paint-directory $which
   clear-busy
}

proc click-up {which} {
   global preferences
   upvar #0 $which-directory directory
   upvar #0 $which-selection selection
   upvar #0 $which-resource resource

   set i [string last / $directory]
   if {$i < 0} then {set directory ""}
   if {$i == 0} then {set directory "/"}
   if {$i > 0} then {set directory [string range $directory 0 [expr $i-1]]}
   set selection {}

   set preferences($resource.directory) $directory

   read-directory $which
   paint-directory $which
}

proc click-down {which} {
   global preferences
   upvar #0 $which-directory directory
   upvar #0 $which-dirlist dirlist
   upvar #0 $which-selection selection
   upvar #0 $which-resource resource

   if {[llength $selection] == 0} then {
      set-footer "no directory/spectrum selected!!!"
      return
   }
   if {[llength $selection] > 1} then {
      set-footer "multiple selections!!!"
      return
   }

   set target [lindex $dirlist [first $selection]]
   if {[string first d $target] != 0} then {
      set-footer "no directory selected!!!"
      return
   }
   if {[second $target] == "."} then {click-redisplay; return}
   if {[second $target] == ".."} then {click-up $which; return}
   if {$directory == ""} {append directory [second $target]} {
        set directory [string trimright $directory /]
        append directory / [second $target]
   }
   set selection {}

   set preferences($resource.directory) $directory

   read-directory $which
   paint-directory $which
}

proc click-select {opt} {
   upvar #0  src-selection selection

   if {"$opt" == "all"} then {
      :modify SLIST :select "0 end"
   } else {
      :modify SLIST :select -1
   }
   set selection [[:path SLIST].list curselection]
}

proc click-list {which s} {
   upvar #0 $which-dirlist dirlist
   upvar #0 $which-selection selection

#insert-debug "click-list $which $s"

   if {$which == "src"} then {set W S} else {set W D}
   set selection $s
    set dd 0
    set ss 0
    foreach e $selection {
        if {[first [lindex $dirlist $e]] == "d"} then {incr dd}
        if {[first [lindex $dirlist $e]] == "s"} then {set ss 1}
    }
    if {$dd>1 || $dd && $ss} then {
        foreach e $selection {
            if {[first [lindex $dirlist $e]] == "d"} then {
                :modify [set W]LIST :deselect $e
            }
        }
        set selection [[:path [set W]LIST].list curselection]
    }

#   insert-debug "dd=$dd; ss=$ss; selection=$selection"
   return
}

proc click-enter w {
   if {$w == "P1"} then {upvar #0 src-selection selection; set W S} \
      else {upvar #0 destn-selection selection; set W D}
   foreach i $selection {:modify [set W]LIST :select $i}
}

proc click-redisplay {} {

   read-directory destn
   paint-directory destn

   read-directory src
   paint-directory src
}

if {$frame == "SPECCOPY"} then {

   proc click-execute {args} {

      set from [get-directory src]
      switch -glob $from {
          *SortSas* -
          *[H,h]ist*  {click-execute-hist}
          default {click-execute-default}
      }
}

   proc click-execute-default {args} {
      upvar #0 src-dirlist dirlist
      upvar #0 src-selection selection
      global env spext
      global savedir

      set from [get-directory src]
      set to   [get-directory destn]

# is spectrum a SOAP path
      set sd [inform ex obtain_SOAPService_byName $from]
      if {$sd == {}} {
# standard EGlib spectrum name (direct or SAS)
        set sd $from
        set sdm ""
      } else {
        set sdm " ($sd)"
      }

      set c 0
      set list ""
      foreach item $selection {
         set s [second [lindex $dirlist $item]]
         append list "$s "
         incr c
      }
      set-footer "copying/saving from $from$sdm to [file join $to $savedir]"
      set-busy
      if {$sd == {}} {
      :file mkdir [file join $to $savedir]
      }
      if {$spext} then {
         set z [catch {eval exec copy-soap-spectra -msf $sd [file join $to $savedir] $list} m]
      } else {
         set z [catch {eval exec copy-soap-spectra $sd [file join $to $savedir] $list} m]
      }
      clear-footer
      clear-busy
      if {$z} then {
         midas-information "$m"
      } else {
         midas-information  "$m"
         set-footer "total of $c [pluralise-spectrum $c] successfully copied/saved to directory [file join $to $savedir]"
      }
      make-dname
      click-redisplay
   }

   proc click-execute-hist {args} {
      upvar #0 src-dirlist dirlist
      upvar #0 src-selection selection
      global env
      global savedir
      global abortflag
      global _footer_only

      set _footer_only 1

      set abortmsg1 "Do you really want to abort the whole save?\n\
                 Click on \"Abort\" if yes\n\
                 If you wish to continue with the copy/save then click on \"continue\""

      set c 0
      foreach item $selection {incr c}

      set abortmsg2 "There are $c spectra to be saved\nThis may take some time but you will be able to\
                 continue with other tasks\n\
                 If you wish to continue with the copy/save then click on \"continue\""

      if {[midas-confirmation "$abortmsg2"] == 0} then {return}

      set number $c

      set from [get-directory src]
      set to   [get-directory destn]

# is spectrum a SOAP path
      set sd [inform ex obtain_SOAPService_byName $from]
      if {$sd == {}} {
# standard EGlib spectrum name (direct or SAS)
        set sd $from
        set sdm ""
      } else {
        set sdm " ($sd)"
      }

      set dir  [file join $to $savedir]

      set z [catch {:file mkdir $dir} m]
      if {$z != 0} then {midas-warning "Unable to create Save directory $dir"; return}

      set abortflag 0
      :modify ABORT :inactive F

      set c 0
      set list ""
      foreach item $selection {

         if {$abortflag == 1} then {
            if {[midas-confirmation "$abortmsg1"] == 0} then {break}
            set abortflag 0
         }

         set s [second [lindex $dirlist $item]]

         set try 1

         while {$try != 0}  {
            set try 0
            if {[expr ($c/25)*25] == $c} {set-footer "copying/saving spectra $s from $from$sdm to $dir"}
            if {$env(platform) == "windows"} then {
                set z [catch {eval exec copy-soap-spectrum $sd/$s $dir/$s.msf} m]
            } else {
                set z [catch {eval exec copy-soap-spectrum $sd/$s $dir/$s} m]
            }
            if {$z} then {
                set msg "Error copying/saving spectra $s - $m"
                set reply [midas_dialog [self frame-name].midasDialog "Error Report for [self frame-title]" \
                   "$msg" "warning" 0 "continue" "retry" "abort"]
                switch $reply {
                   0    {continue}
                   1    {set try 1}
                   2    {set abortflag 1}
                } 
            } else {
                if {[expr ($c/25)*25] == $c} {:modify PROGRESS :value [expr ($c * 100) / $number]; update idletasks}
                incr c
            }
         }

      }
      :modify PROGRESS :value [expr ($c * 100) / $number]
      set-footer "total of $c spectra successfully copied/saved to directory $dir"

      :modify ABORT :inactive T

      make-dname
      click-redisplay
   }
}

if {$frame == "IDB"} then {
   proc click-execute {args} {
      upvar #0 src-dirlist directorylist
      upvar #0 src-selection selection
      global format treatments option ext savedir

      if {[llength $selection] == 0} then {midas-warning "You haven't selected any files to import"; return}

      set from [get-directory src]

      if {$option == 1} then {
#    display only - use tmp directory
         midas-check-for-temp
         click-directory destn [pwd]
         make-dname
      }
         
      set to [get-directory destn]
      :file mkdir [file join $to $savedir]

      set total 0
      set list ""
      foreach i $selection {
         set target [lindex $directorylist $i]
         set file [last $target]
         if {[first $target] == "d"} then {set-footer "ignoring $target since it's a directory"}

         set egfile [do-extension [lindex $treatments $ext] $file]
         set fromfile [file join $from $file]
         set tofile   [file join $to $savedir $egfile]
         set-footer "importing $fromfile as $tofile ..."
         set z [catch {switch -- $format {
            0 {exec ascii-to-eg -from $fromfile -to $tofile -format y}
            1 {exec ascii-to-eg -from $fromfile -to $tofile -format xy}
            2 {exec bmp-to-midas $fromfile $tofile}
            5 {exec sdb-to-eg   -from $fromfile -to $tofile}
            3 {exec ana-to-eg         $fromfile     $tofile}
            4 {exec spe-to-eg   -from $fromfile -to $tofile}
         }} m]
         if {$z == 0} then {
            set-footer "$m"
            incr total
            append list "$tofile "
         } else {
            midas-warning "$m"
         }
      }
      set-footer "$total [pluralise-spectrum $total] successfully imported"
      if {$option > 0 && $total > 0} then {inform sd show $list}
   }
}

if {$frame == "EXP"} then {
   proc click-execute {args} {
      upvar #0 src-dirlist directorylist
      upvar #0 src-selection selection
      global format formats treatments ext savedir

      if {[llength $selection] == 0} then {midas-warning "You haven't selected any spectra to export"; return}

      set from [get-directory src]
      set to [get-directory destn]

      :file mkdir [file join $to $savedir]

      midas-check-for-temp
      set total 0
      foreach i $selection {
         set target [lindex $directorylist $i]
         set file [last $target]
         if {[first $target] == "d"} then {set-footer "ignoring $target since it's a directory"}

         set egfile [do-extension [lindex $treatments $ext] $file]
         set fromfile [file join $from $file]
         set tofile   [file join $to $savedir $egfile]
# is spectrum a SOAP path
         set sd [inform ex obtain_SOAPService_byName $fromfile]
         if {$sd != {}} {
# build spectrum name in current (temp) directory, replacing /'s in path with _ (e.g. /MemSas/Spect => /tmp/tcl123/MemSAS_Spect)
           set ns [join [tail [split $fromfile /]] _]
           set ts [file join [pwd] $ns]
           catch {eg "(spectrum :path '$ts' !delete)"}
           catch {eval exec copy-soap-spectrum $fromfile $ts} m
         } else {
           set ts $fromfile
         }
         set-footer "exporting $fromfile as $tofile ..."
#  The first line in the switch below should read:
#  "Ascii Y only" {exec eg-to-ascii -spectrum $fromfile -format y > $tofile}
#  Due to a bug in some versions of eg-to-ascii we call it with no -format
#  which calls the -format y code
         set z [catch {switch -- $format {
            0    {exec eg-to-ascii -spectrum $ts > $tofile}
            1    {exec eg-to-ascii -spectrum $ts -format xy > $tofile}
            2    {exec eg-to-ascii -spectrum $ts -format 5y > $tofile}
            3    {exec eg-to-ascii -spectrum $ts -format c > $tofile}
            4    {exec eg-to-ascii -spectrum $ts -format r > $tofile}
            5    {exec eg-to-html -spectrum $ts -title $fromfile -compress > $tofile}
         }} m]
         if {$z == 0} then {
            set-footer "$m"
            incr total
         } else {
            midas-warning "$m"
         }
         if {$sd != {}} {
            catch {eg "(spectrum :path '$ts' !delete)"}
         }
      }
      set-footer "$total [pluralise-spectrum $total] successfully exported"
   }
}



proc click-dname {v} {global savedir; set savedir $v}

proc click-spext {v} {global spext; set spext $v}


switch $frame {
  SPECCOPY {

     proc make-dname {} {
        global defaultsrcresource
        global savedir
        if {$defaultsrcresource == "direct"} then {
           set savedir "specs-[date +%Y%h%d-%H.%M.%S]"
        } else {
           set savedir "$defaultsrcresource-[date +%Y%h%d-%H.%M.%S]"
        }
        :modify DDIR :value $savedir
     }

  }
  EXP -
  IDB {

     proc make-dname {} {
        global savedir
        set savedir "specs-[date +%Y%h%d-%H.%M.%S]"
        :modify DDIR :value $savedir
     }

  }
}

proc init-src {} {
   global env preferences frame 
   upvar #0 src-resource resource
   upvar #0 src-directory directory

switch $frame {
  EXP -
  SPECCOPY {

      upvar #0 src-resources resources
      global defaultsrcresource

      make-src-resource-list

      if {[lsearch $resources $defaultsrcresource] == -1} then {
         set resource [first $resources]
      } else {
         set resource $defaultsrcresource
      }
      if {$resource == "direct"} then {set directory $preferences(direct.directory)}

      :modify SRESOURCEMENU :strings $resources
      :modify SRESOURCE :value $resource
  }
  IDB {
      set directory $preferences(direct.directory)
  }
}

#    process for system independance

   if {$directory != ""} then {set directory [eval file join [file split $directory]]}

   read-directory src
   paint-directory src
}

proc init-destn {} {
   global env preferences frame 
   upvar #0 destn-directory directory
   upvar #0 destn-resource resource

switch $frame {
  IDB -
  SPECCOPY { 

      upvar #0 destn-resources resources
      global defaultdestnresource

      make-destn-resource-list

      if {[lsearch $resources $defaultdestnresource] == -1} then {
        set resource [first $resources]
      } else {
        set resource $defaultdestnresource
      }
      if {$resource == "direct"} then {set directory  $preferences(direct.directory)}

      :modify DRESOURCEMENU :strings $resources
      :modify DRESOURCE :value $resource
  }
  EXP {
      set directory $preferences(direct.directory)
  }
}

#    process for system independance

   if {$directory != ""} then {set directory [eval file join [file split $directory]]}

   read-directory destn
   paint-directory destn
}

proc double-click arg {
   global debug frame

   if {$debug} then {puts stderr "double-click with argument \{$arg\}"}
# insert-debug "double-click entered with argument \{$arg\}"
   set f [lindex $arg 0]
   set w [lindex $arg 2]
   set v [lindex $arg 3]

   if {$w == "SLIST"} then {set which src} else {set which destn}
      upvar #0 $which-selection selection

   switch -glob $w {
        *LIST  {
#            if {[llength $selection_last] > [llength $selection]} then {set selection $selection_last}
            click-down $which
        }
        default      {puts stdout $arg}
   }
}
proc click arg {
   global debug
   if {$debug} then {puts stderr "click with argument \{$arg\}"}
   clear-footer
   set f [lindex $arg 0]
   set c [lindex $arg 1]
   set w [lindex $arg 2]
   set v [lindex $arg 3]
   if {$c==":quit"} then {click-quit; return}
   if {$c==":Enter"} then {click-enter $w; return}
   switch $w  {
      SRESOURCEMENU   -
      SRESOURCE       {click-resource src $v}
      SRESOURCESORTTYPE   {click-sorttype src $v}
      DRESOURCEMENU   -
      DRESOURCE       {click-resource destn $v}
      PATTERNMENU     -
      PATTERN         {click-pattern $v}
      SDIRECTORY      {click-directory src $v}
      DDIRECTORY      {click-directory destn $v}
      DDIR            {click-dname $v}
      SLIST           {click-list src [lindex $arg 4]}
      DLIST           {click-list destn [lindex $arg 4]}

      default {
         set p "click-[lowercase $w]"
         if {[info procs $p] == "$p"} then {$p $v} else {set-footer "no handler for widget $w"}
      }
   }
}

proc start args {
   global started defaultsrcresource

   if {$started == 0} then {make-frame; load_preferences}
   set started 1
   open-frame

   if {[first $args] != ""} then {set defaultsrcresource [first $args]} else {set defaultsrcresource "direct"}

   init-src
   init-destn

   make-dname

   click-redisplay
}


proc make-frame {} {
   upvar #0 src-resources sresources
    upvar #0 src-sorttypes ssorttypes
   upvar #0 destn-resources dresources
   global frame
   global patternmenu idboptionmenu
   global spext

set rows 12
set cols 36

  :frame [self frame-name] :label "[self frame-title]" :show-footer T \
      :icon-name "[self icon-title]"

  :panel P1 :layout L :padx 5 :pady 5
     :layout H; :row-gap 5; :col-gap 5

   :enable P1 Enter

switch $frame {
  EXP -
  SPECCOPY {
     :menubutton SRESOURCEMENU :label "Source Resource" :menu $sresources
     :text SRESOURCE :label "" :w 10 :value [first $sresources]
     :menubutton SRESOURCESORTTYPE :label "numeric" :menu $ssorttypes
  }
  IDB {
     :message SRESOURCE :label "Source" 
     :message SPACE :label "          " :w 20
     :menubutton SRESOURCESORTTYPE :label "numeric" :menu $ssorttypes
  }
}
     :next-row T
     :text SDIRECTORY :label Directory :w [expr $cols - 4] :shifters T
     :next-row T
     :list SLIST :rows $rows :cols $cols :exclusive F :double-click T
     :next-row T
     :menubutton PATTERNMENU :label Selection :menu $patternmenu
     :text PATTERN :label "" :w [expr $cols - 6] :value [first $patternmenu]
     :next-row T
     :button SSELECT   :label "Select All"   :command "click-select all"
     :button SDESELECT :label "Deselect All" :command "click-select none"
     :button SUP   :label Up   :command "click-up src"
     :button SDOWN :label Down :command "click-down src"

  :panel P2 :layout L :padx 5 :pady 5
     :layout H; :row-gap 5; :col-gap 5

   :enable P2 Enter

switch $frame {
  IDB -
  SPECCOPY {
     :menubutton DRESOURCEMENU :label "Destination Resource" :menu $dresources
     :text DRESOURCE :label "" :w 10 :value [first $dresources]
  }
  EXP {
     :message DRESOURCE :label "Destination" 
  }
}
     :next-row T
     :text DDIRECTORY :label Directory :w [expr $cols - 4] :shifters T
     :next-row T
     :list DLIST :rows $rows :cols $cols :exclusive T  :double-click T
     :next-row T
     :text DDIR    :label "Directory" :w 26
     :button DNAME :label "TimeStamp" :command "make-dname"
     :next-row T
switch $frame {
  IDB -
  EXP {
     :hskip 180
  }
  SPECCOPY {
     :checkbox SPEXT :label "Append \".msf\"" :value $spext
     :hskip 80
  }
}
     :button DUP   :label Up   :command "click-up destn"
     :button DDOWN :label Down :command "click-down destn"

   :panel BUTTONS :layout B :padx 5 :after FOOTER
     :layout H; :col-gap 20; :row-gap 5

switch $frame {
  SPECCOPY {
     :button EXECUTE        :label "Execute"  :command click-execute

     :col-gap 0
     :message PMSG :label progress
     :gauge PROGRESS :label "" :min 0 :max 100 :min-tick-label " " :max-tick-label " "    \
           :gauge-width 200 :gauge-height 10 :inactive T 
     [:path PROGRESS].scale configure -troughcolor white -background black -sliderlength 20
     :col-gap 20

     :button ABORT          :label "Abort"    :command click-abort :inactive T
  }
  IDB {
       global formats treatments option
     :choice-stack OPTION    :label Option     :strings $idboptionmenu
     :hskip 30
     :choice-stack FORMAT    :label Format     :strings $formats
     :hskip 30
     :choice-stack EXTENSION :label Extension  :strings $treatments 
     :next-row T
     :button       EXECUTE   :label "Execute"  :command click-execute
     :hskip 50; :col-gap 50
  }
  EXP {
       global formats treatments
     :choice-stack FORMAT    :label Format     :strings $formats
     :hskip 30
     :choice-stack EXTENSION :label Extension  :strings $treatments 
     :next-row T
     :button       EXECUTE   :label "Execute"  :command click-execute
     :hskip 50; :col-gap 50
  }
}

     :button REDISPLAY   :label Redisplay  :command click-redisplay
     :button HELP        :label Help       :command click-help

   :show T
   update idletasks
}
