# Spectrum Addition application

# Mon Dec 13 18:57:58 GMT 1993, DB
#   started by copying cal.tcl and modifying

package require ServerAccess 2.0
package require SpectrumClient

set started 0

set frame ADD
set frametitle "Adding Up Spectra"
set icontitle  SpecAdd

set tmplist {}

set default_factor 1.0
set factor ""
set name ""
set directory ""
set resultname ""
set resultdirectory ""
set summandlist {}
set summandstrings {}
set selection -1


proc repaint {} {
   global name factor directory resultname resultdirectory
    :modify FACTOR :value $factor
    :modify NAME   :value $name
    :modify DIRECTORY :value $directory
    :modify RESULT-NAME :value $resultname
    :modify RESULT-DIRECTORY :value $resultdirectory
}

proc format-summands l {
   set ll {}
   foreach f $l {lappend ll [format "%8.3f %12s   %-24s" \
      [first $f] [second $f] [third $f]]}
   return $ll
}

proc load-summand n {
   global name factor directory summandlist
   set summand [lindex $summandlist $n]
   set factor [first $summand]
   set name [second $summand]
   set directory [third $summand]
}

proc append-spectrum s {
   global debug summandlist default_factor
   if {$debug} then {puts stdout "append-spectrum $s"}
   set name [last [split $s "/"]]
   set directory [join [front [split $s "/"]] "/"]
   set factor $default_factor
   lappend summandlist [list $factor $name $directory]
}

proc paint-summandlist {} {
   global summandlist summandstrings selection
   set summandstrings [format-summands $summandlist]
   :modify LIST :empty T :strings $summandstrings
   :modify LIST :select $selection
}

proc check-summand {} {
   global name factor directory
   if {[scan $factor "%f" factor] != 1 && $factor != ""} then {return 1}
   if {[scan $name "%s" name] != 1} then {return 1}
   if {[scan $directory "%s" directory] != 1} then {return 1}
   return 0
}

proc click-append {} {
   global factor default_factor name directory summandlist
   if {[check-summand] != 0} then \
      {midas-warning "you haven't supplied enough good information for a summand!!!"; return}
   set f $factor; if {$f == ""} {set f $default_factor}
   lappend summandlist [list $f $name $directory]
   paint-summandlist
   clear-footer
}

proc click-replace {} {
   global selection name factor default_factor directory summandlist
   if {$selection < 0} then \
      {set-footer "you haven't selected a summand to replace!"; return}
   if {[check-summand] != 0} then \
      {midas-warning "you haven't supplied enough good information for a summand!!!"; return}
   set f $factor; if {$f == ""} {set f $default_factor}

   set summandlist [lreplace $summandlist $selection $selection \
                     [list $f $name $directory]]
   paint-summandlist
   clear-footer
}

proc click-delete {} {
   global selection summandlist
   if {$selection < 0} then \
      {set-footer "you haven't selected a summand to delete!"; return}
   set summandlist [lreplace $summandlist $selection $selection]
   set selection -1
   paint-summandlist
   clear-footer
}

proc click-delete-all {} {
   global selection summandlist
   set summandlist {}
   set selection -1
   paint-summandlist
   clear-footer
}

proc make-summand-exp {ss} {
global EGallow tmplist
   set tmplist {}
   set ll {}
   midas-check-for-temp
   foreach p $ss {
     set t [join [list [third $p] [transparent [second $p]]] /]
     set sd [inform ex obtain_SOAPService_byName $t]
     if {$sd != {}} {
       set cs [join [list $sd [tail [tail [split $t /]]]] /]
     } else {
       set cs $t
     }
     if {$cs != $t} {
       set ns [join [tail [split $t /]] _]
       set ts [join [list [pwd] $ns] /]
       set tmpAllow $EGallow; set EGallow 0x30000; EG "spectrum :path '$ts' !delete"; set EGallow $tmpAllow
       catch {eval exec copy-soap-spectrum $cs $ts} m
       if {[lsearch $tmplist $ts] == -1} {lappend tmplist $ts}
     } else {
       set ts $cs
     }
     append ll "[list [first $p]  $ts] "
   }
   return $ll
}

proc delete-tmp-specs {} {
  global tmplist
  foreach ts $tmplist { catch {eg "(spectrum :path '$ts' !delete)"} }
}

proc confirm-action {s} {
   set m "Spectrum $s already exists\nPlease confirm that you want to overwrite it"
   return [midas-confirmation $m]
}

proc click-addup {} {
   global resultdirectory resultname summandlist tmplist
   if {[llength $summandlist] == 0} then {
      set-footer "no summands selected!!!"
      return
   }
   if {$resultname == {}} then {
      set-footer "You haven't given a name for the result!!!"
      return
   }
   if {$resultdirectory == {}} then {
      set-footer "You haven't given a directory for the result!!!"
      return
   }
   set new [catch {eg "(spectrum :name '$resultdirectory/$resultname' ?spec)"} m]
   if {$new == 0} then {
       if {[confirm-action $resultdirectory/$resultname] == 0} then {
          set-footer "action cancelled"
          return 
       }
   }
   set-footer "Adding spectra..."
   set rd [inform ex obtain_SOAPService_byName $resultdirectory]
   if {$rd != {}} {
      midas-check-for-temp
      set rs [join [list [pwd] [set resultname]_Result] /]
      set z [catch {eg "(spectrum :name '$rs' !delete)"} m]
   } else {
      set rs $resultdirectory/$resultname
   }
   set z [catch {eval exec specaddition -result $rs -spectra [make-summand-exp $summandlist]} m]
   if {$z == 0 && $rd != {}} {
      if {!$new} {set z [catch {eg "(spectrum :name '$resultdirectory/$resultname' !delete)"} m]}
      set z [catch {eval exec copy-soap-spectrum $rs $rd/$resultname} x]
      lappend tmplist $rs
   }
   delete-tmp-specs
   if {$z != 0} then {set-footer $m; return}
   set-footer "Result spectrum $resultdirectory/$resultname successfully created"
   send sb "redisplay-if-showing $resultdirectory"
}

proc click-list {v s} {
   global selection
   set selection $s
   :modify LIST :select $s
   load-summand $s
   repaint
   clear-footer
}

proc click-factor {v} {
   global factor
   set z [scan $v "%f" zz]
   if {$z == 0} then {set-footer "$v is not an acceptable number"; repaint; return}
   set factor $v
   clear-footer
}

proc click-name {v} {
   global name
   set name $v
   clear-footer
}

proc click-directory {v} {
   global directory
   set directory $v
   clear-footer
}

proc click-result-name {v} {
   global resultname
   set resultname $v
   clear-footer
}

proc click-result-directory {v} {
   global resultdirectory
   set resultdirectory $v
   clear-footer
}

proc click-redisplay {} {
   paint-summandlist
   repaint
   clear-footer
}

proc start args {
   global started
   if {[llength $args] == 1} then {set args [first $args] }
   if {$started == 0} then {make-frame; set started 1} else {open-frame}
   foreach s $args {append-spectrum $s}
   click-redisplay
}


proc make-frame {} {
   global env axismenu ordermenu unitsmenu

   :frame [self frame-name] :label "[self frame-title]" :show-footer T  \
      :icon-image "@$env(ICONHOME)/spectrum"  \
      :icon-name [self icon-title]

    :panel P1 :layout L :pady 5 :padx 10
     :layout V; :row-gap 5
     :text FACTOR     :label Factor: :w 12 :valuex 10c
     :text NAME       :label Name:   :w 20 :valuex 10c
     :text DIRECTORY  :label Directory: :w 20 :valuex 10c
     :vskip 30
     :text RESULT-NAME :label Result:   :w 20 :valuex 10c
     :text RESULT-DIRECTORY :label Directory: :w 20 :valuex 10c

    :panel P2 :layout L :pady 5 :padx 5
     :layout V; :row-gap 10 
     :message M1 :label "     factor             name                         directory" :bold T
     :list LIST :rows 8 :cols 40 :exclusive T

    :panel P3 :layout B :after FOOTER :pady 5 :padx 10
     :layout H; :row-gap 10; :col-gap 5
     :button APPEND; :button REPLACE; :button DELETE
     :button DELETE-ALL :label "Delete All"
     :button ADDUP      :label "Add Up"
     :next-row T
     :button REDISPLAY
     :hskip 250
     :button HELP

  :show T
}
