
#package provide SpectrumAccess 2.0

set CurrentSOAPserver ""
set CurrentUrn ""

proc spect {arg} {
    global ServerAccessTrace MIDASAccessServer

#    this takes the old EG command argument string and converts into the new format

   if {$ServerAccessTrace} {insert-debug "spect received args $arg"}

   set Arg [string range $arg 1 [expr [string length $arg]-2]]  ;#   remove outer ()s 

   set Querys 0
   set Actions 0

   set Names 0
   set Users 0
   set Passes 0
   set Paths 0
   set Bases 0
   set Bases2 0
   set Ranges 0
   set Ranges2 0
   set Layouts 0
   set Types 0
   set Titles 0
   set Labels 0
   set Infos 0
   set Infonums 0
   set Cals 0
   set Dims 0


   set Action ""
   set Query ""
   set Execute ""

   set Name ""
   set User ""
   set Pass ""
   set Path ""
   set Base 0
   set Base2 0
   set Range 0
   set Range2 0
   set Layout 0
   set Type 0
   set Title ""
   set Label ""
   set Info ""
   set Infonum 0
   set Cal ""
   set Dim 0

   switch [first $Arg] {

       spectrum {

          set Cmd [regsub -all ' [tail $Arg] \"]      ;#    We need to replace ' characters in the old syntax with " characters

          if {$ServerAccessTrace} {insert-debug "Cmd is: $Cmd"}
          set i 0
          while {$i < [llength $Cmd]} {
            set p [lindex $Cmd $i]
            incr i

            switch $p {

                :name     {set Name "[lindex $Cmd $i]"; incr Names; incr i}

                :path     {set Path "[lindex $Cmd $i]"; incr Paths; incr i}
                :user     {set User "[lindex $Cmd $i]"; incr Users; incr i}
                :pass     {set Pass "[lindex $Cmd $i]"; incr Passes; incr i}
                :base     {set Base "[lindex $Cmd $i]"; if {!$Bases} {incr Bases}; incr i}
                :base2    {set Base2 "[lindex $Cmd $i]"; if {!$Bases2} {incr Bases2}; incr i}
                :range    {set Range "[lindex $Cmd $i]"; if {!$Ranges} {incr Ranges}; incr i}
                :range2   {set Range2 "[lindex $Cmd $i]"; if {!$Ranges2} {incr Ranges2}; incr i}
                :layout   {set Layout "[lindex $Cmd $i]"; incr Layouts; incr i}
                :type     {set Type "[lindex $Cmd $i]"; incr Types; incr i}
                :infonum  {set Infonum "[lindex $Cmd $i]"; incr Infonums; incr i}
                :dim      {set Dim "[lindex $Cmd $i]"; incr Dims; incr i}

                :timeout  {incr i}

                :title    {set Execute $p; set Title "[lindex $Cmd $i]"; incr Titles; incr i}
                :label    {set Execute $p; set Label "[lindex $Cmd $i]"; incr Labels; incr i}
                :info     {set Execute $p; set Info "[lindex $Cmd $i]"; incr Infos; incr i}
                :cal      {set Execute $p; set Cal "[lindex $Cmd $i]"; incr Cals; incr i}

                ?names  -
                ?spec -
                ?addr -
                ?title -
                ?label -
                ?info -
                ?cal -
                ?error    {set Query $p; incr Querys}

                !auth -
                !path -
                !new -
                !delete -
                !zero -
                !ping     {set Action $p; incr Actions;}

                default {error 0x30005 "Invalid token: $p"}
            }
          }

          if {$Actions > 1} {error 0x30005 "More than 1 action token: $Cmd"}
          if {$Querys > 1} {error 0x30005 "More than 1 query token: $Cmd"}
          if {[expr $Actions + $Querys + $Titles +$Labels + $Infos + $Cals] != 1} {error 0x30005 "Command structure error: $Cmd"}

          if {[expr $Names + $Paths] != 1 && [expr $Names + $Paths] != 2} {error 0x30005 "Command structure error: $Cmd"}
          if {$Names == 1 && $Query == "?names"} {error 0x30005 "Command structure error: $Cmd"}
#          if {$Names == 0 && $Query != "?names"} {error 0x30005 "Command structure error: $Cmd"}

          
          if {$Titles > 1} {error 0x30005 "More than 1 :title token: $Cmd"}
          if {$Labels > 1} {error 0x30005 "More than 1 :label token: $Cmd"}
          if {$Infos > 1}  {error 0x30005 "More than 1 :info token: $Cmd"}
          if {$Cals > 1}   {error 0x30005 "More than 1 :cal token: $Cmd"}
          if {$Dims > 1}   {error 0x30005 "More than 1 :dim token: $Cmd"}

          if {[expr $Actions + $Querys] == 0 && [expr $Titles +$Labels + $Infos + $Cals] != 1} {error 0x30005 "Command structure error: $Cmd"}

           if {$ServerAccessTrace} {insert-debug "Names $Names, Paths $Paths, Querys $Querys"}

#    look at :name and (if present) :path token (at least one must be present) and extract the server
#    ?names is anomalous, it doesn't have a Name - just a Path
#    Path & Name can be:
#		/server/ <rel_path>/spectrum
#		/server/ spectrum
#		/server/ /<full_path>/spectrum
#		/server/ /spectrum
#		<rel_path>/spectrum
#		spectrum
#		/<full_path>/ spectrum
#		/spectrum
#
#       /<something>/ is server or full path
# Cannot distinguish between
#		/server/spectrum & /<full_path>/spectrum
# when <full_path> has only 1 element e.g. between /hist/spectrum & /data/spectrum
# Have to separate out 1st element then look up whether it's a server
#
# Build PathName as a concatenation of Path & Name. May need to add a "/" between
# them. If Path has only 1 element (e.g.
#

          if {$Path == ""} then {
             set PathName $Name
          } elseif {$Name == ""} then {
             set PathName $Path
          } else {
             set pt [split $Path /]
             set nm [split $Name /]

             if {[first $pt]=={} && [llength $pt]==3} then {
                set J ""
             } elseif {[first $pt]=={} && [llength $pt]==2} then {
                 set J /
             } else {
                if {[last $pt] == {} || [first $nm] == {}} {set J ""} {set J /}
             }
             set PathName [join [list $Path $Name] $J]
          }

   if {$ServerAccessTrace} {insert-debug "spec parsed Path: $Path, Name: $Name => $PathName"}
          switch $Action {

             !new {
# Allow default bases of 0, don't allow 1st dimension range of 0
                 set RangesAll [expr $Ranges + $Ranges2]
                 set NumArgs [expr $Bases + $Bases2 + $RangesAll]
                 if {$NumArgs < 1 || $NumArgs > 4} {
                    error 0x30005 "Command structure error: $Cmd"
                 }
                 if {$Ranges != 1 || $Range == 0} {
                    error 0x30005 "Command structure error: $Cmd"
                 }
                 if {$NumArgs == 2 && $RangesAll != 2 && $Bases != 1} {
                    error 0x30005 "Command structure error: $Cmd"
                 }
                 if {$NumArgs > 2 && $RangesAll != 2} {
                    error 0x30005 "Command structure error: $Cmd"
                 }
                 return [MIDASCreateSpectrum $PathName $Base $Range $Base2 $Range2]
             }

             !delete {
                 return [MIDASDeleteSpectrum $PathName]
             }

             !zero {
                 return [MIDASZeroSpectrum $PathName]
             }

             !ping {return 0}
          }

          switch $Query {
              ?names {
                  return [MIDASInquireSpectra $PathName]
              }

              ?spec {
                  return [MIDASSpectrumDetails $PathName]
              }

              ?title {
                  return [MIDASReadSpectrumTitle $PathName]
              }

              ?label {
                  return [MIDASReadSpectrumLabel $PathName]
              }

              ?info {
                  return [MIDASReadSpectrumInfo $PathName $Infonum]
              }

              ?cal {
                  return [MIDASReadSpectrumCalib $PathName $Dim]
              }
          }

          switch $Execute {

              :title {
if {$ServerAccessTrace} {insert-debug "Calling MIDASWriteSpectrumTitle PathName: $PathName Title: $Title"}
                  return [MIDASWriteSpectrumTitle $PathName $Title]
              }

              :label {
if {$ServerAccessTrace} {insert-debug "Calling MIDASWriteSpectrumLabel PathName: $PathName Label: $Label"}
                  return [MIDASWriteSpectrumLabel $PathName $Label]
              }

              :info {
if {$ServerAccessTrace} {insert-debug "Calling MIDASWriteSpectrumInfo PathName: $PathName Num: $Infonum Info: $Info"}
                  return [MIDASWriteSpectrumInfo $PathName $Infonum $Info]
              }

              :cal {
if {$ServerAccessTrace} {insert-debug "Calling MIDASWriteSpectrumCalib PathName: $PathName Dim: $Dim Cal: $Cal"}
                  return [MIDASWriteSpectrumCalib $PathName $Dim $Cal]
              }

          }

          error 0x10001 "Internal logic error"   ;#   We should never get here!

       }

       tape {__eg__ "$arg"}

       default {__eg__ "$arg"}

   }

}


#    Error messages for EG  -  taken from eglib.h   (some messages not applicable to spectrum access are omitted)

set EGerrInfoMsg(0) "OK"   ;#  So we can use same code for a good return

set EGerrInfoMsg(0x10001) "Not yet implemented"
set EGerrInfoMsg(0x10002) "No suitable resource claimed"
set EGerrInfoMsg(0x10003) "Name or pattern too long"
set EGerrInfoMsg(0x10008) "No experiment connected"
set EGerrInfoMsg(0x10015) "Cannot create RPC client"
set EGerrInfoMsg(0x1001c) "No reply from ping attempt"

set EGerrInfoMsg(0x30001) "Authentication failure"
set EGerrInfoMsg(0x30002) "Resource already in use"
set EGerrInfoMsg(0x30003) "Capability invalid"
set EGerrInfoMsg(0x30004) "Pathname invalid"
set EGerrInfoMsg(0x30005) "Parameter invalid"
set EGerrInfoMsg(0x30006) "Not a spectrum"
set EGerrInfoMsg(0x30007) "Not a directory"
set EGerrInfoMsg(0x30008) "Data access error"
set EGerrInfoMsg(0x30009) "Count too small"

proc EGerrInfo {rc} {
    global EGerrInfoMsg

    if {[info exists EGerrInfoMsg($rc)]} then {return "$EGerrInfoMsg($rc)"} else {return "Unknown error"}
}

# The following approach is probably not strictly necessary
# but for ease we'll map this against the equivalent register access functions

proc Obtain_Spectrum_SOAPservers {server spectrum} {

#           if the spectrum name begins MemSas. then we look for a server/name  MemSas before using the supplied server

     if {[string equal -length 7 $spectrum "MemSas."]} {
         set SOAPservers [inform ex obtain_SOAPServer_byName "MemSas"]   ;# Role gets priority
         if {$SOAPservers != ""} {return [list "MemSas" $SOAPservers]}
     }

#    end of special case checks

     set SOAPservers [inform ex obtain_SOAPServer_byRole $server]   ;# Role gets priority
     if {$SOAPservers != ""} {return [list $server $SOAPservers]}

     set SOAPservers [inform ex obtain_SOAPServer_byName $server]
     if {$SOAPservers != ""} {return [list $server $SOAPservers]}

     return ""     ;#  no suitable SOAP server found
}

proc MIDASSpectrumAccess {Method PathName args} {
    global MIDASAccessServer ServerAccessTrace LastSOAPMethodName

     if {$ServerAccessTrace} {insert-debug "MIDASSpectrumAccess: $Method $PathName NumArgs=[llength $args] Args=$args"}

#    look at the Name argument and split into server + path&name
#    note that "server" night be a red herring, it could be the first part of a direct access absolute path

     set ptnm [split [first $PathName] /]
if {$ServerAccessTrace} {insert-debug "MIDASSpectrumAccess: PathName splits to $ptnm"}
     if {[first $ptnm] != {}} {
       set server ""
       set pathname $PathName
       set spectrum [last $ptnm]
     } else {
       set server [second $ptnm]
       set pathname [join [tail [tail $ptnm]] /]
       set spectrum [last $ptnm]
     }

#    start to determine the access method
#    if server is not specified use direct access (via legacy calls for now)
#    otherwise server is either an apparatus Role or is the name from a specific apparatus

       set RPCservers ""
       set SOAPservers ""

#    first try legacy RPC servers

if {$ServerAccessTrace} {insert-debug "MIDASSpectrumAccess: server is $server, pathname is $pathname"}
     if {$server != ""} then {
       set RPCservers [inform ex obtain_RPCServer_byRole $server]   ;# Role gets priority
       if {$RPCservers == ""} then {set RPCservers [inform ex obtain_RPCServer_byName $server]}

#    then try SOAP/XML servers

     set SOAPservers [Obtain_Spectrum_SOAPservers $server $spectrum]

#       set SOAPservers [inform ex obtain_SOAPServer_byRole $server]   ;# Role gets priority
#       if {$SOAPservers == ""} then {set SOAPservers [inform ex obtain_SOAPServer_byName $server]}

     }

# N.B. Not an error if neither RPC nor SOAP is available, could be direct access (via RPC interface)
     if {$ServerAccessTrace} {insert-debug "RPCservers=$RPCservers; SOAPservers=$SOAPservers"}

# if direct access or no SOAP servers use legacy RPC method
     if {$SOAPservers == "" || $server == ""} then {

        if {$ServerAccessTrace} {
            set RPC "RPC"
            if {$RPCservers == ""} then {set RPC "Direct Access"}
            insert-debug "No SOAP, using $RPC $Method $server $pathname $args"
        }

        switch $Method  {

            CreateSpectrum   {
                set z [catch {__eg__ "(spectrum :name '$PathName' :base [first $args] :range [second $args] :base2 [third $args] :range2 [fourth $args] !new)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return ""
           }

            DeleteSpectrum   {
                set z [catch {__eg__ "(spectrum :name    '$PathName' !delete)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return ""
           }

            ZeroSpectrum     {
                set z [catch {__eg__ "(spectrum :name    '$PathName' !zero)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return ""
            }

            InquireSpectra         {
                set z [catch {__eg__ "(spectrum :path '$PathName' ?names)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumDetails         {
                set z [catch {__eg__ "(spectrum :path '$PathName' ?spec)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumGetTitle           {
                set z [catch {__eg__ "(spectrum :path '$PathName' ?title)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumPutTitle           {
                set z [catch {__eg__ "(spectrum :path '$PathName' :title '[first $args]')"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumGetLabel           {
                set z [catch {__eg__ "(spectrum :path '$PathName' ?label)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumPutLabel           {
                set z [catch {__eg__ "(spectrum :path '$PathName' :label '[first $args]')"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumGetInfo           {
                set z [catch {__eg__ "(spectrum :path '$PathName' :infonum [first $args] ?info)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumPutInfo           {
                set z [catch {__eg__ "(spectrum :path '$PathName' :infonum [first $args] :info '[second $args]')"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumGetCalib           {
                set z [catch {__eg__ "(spectrum :path '$PathName' :dim [first $args] ?cal)"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            SpectrumPutCalib           {
                set z [catch {__eg__ "(spectrum :path '$PathName' :dim [first $args] :cal '[second $args]')"} reply]
                if {$z != 0} then {
                   set rc [first $reply]
                   return -code error -errorcode "$rc" -errorinfo "$Method: $PathName [EGerrInfo $rc]"
                }
                return $reply
            }

            ServerDebug   -
            ServerLogging -
            ServerVerbose {}

            default {return -code error -errorcode 0x10001 -errorinfo "Internal logic error"}
        }

        return -code error -errorcode 0x10001 -errorinfo "Internal logic error"
     }


#    Try both RPC and SOAP servers as available

     set rc {}

     if {$RPCservers != ""} then {    ;#  first try RPC servers 

           if {$ServerAccessTrace} {insert-debug "First using RPC $Method $PathName $args"}

           switch $Method  {
               CreateSpectrum           {set z [catch {__eg__ "(spectrum :name '$PathName' :base '[first $args]' :range '[second $args]' :base2 '[third $args]' :range2 '[fourth $args]']' !new)"} m]}
               DeleteSpectrum           {set z [catch {__eg__ "(spectrum :name '$PathName' !delete)"} m]}
               ZeroSpectrum             {set z [catch {__eg__ "(spectrum :name '$PathName' !zero)"} m]}
               InquireSpectra           {set z [catch {__eg__ "(spectrum :path '$PathName' ?names)"} m]}
               SpectrumDetails          {set z [catch {__eg__ "(spectrum :path '$PathName' ?spec)"} m]}
               SpectrumGetTitle         {set z [catch {__eg__ "(spectrum :path '$PathName' ?title)"} m]}
               SpectrumPutTitle         {set z [catch {__eg__ "(spectrum :path '$PathName' :title '[first $args]')"} m]}
               SpectrumGetLabel         {set z [catch {__eg__ "(spectrum :path '$PathName' ?label)"} m]}
               SpectrumPutLabel         {set z [catch {__eg__ "(spectrum :path '$PathName' :label '[first $args]')"} m]}
               SpectrumGetInfo          {set z [catch {__eg__ "(spectrum :path '$PathName' :infonum [first $args] ?info)"} m]}
               SpectrumPutInfo          {set z [catch {__eg__ "(spectrum :path '$PathName' :infonum [first $args] :info '[second $args]')"} m]}
               SpectrumGetCalib         {set z [catch {__eg__ "(spectrum :path '$PathName' :dim [first $args] ?cal)"} m]}
               SpectrumPutCalib         {set z [catch {__eg__ "(spectrum :path '$PathName' :dim [first $args] :cal '[second $args]')"} m]}

               ServerDebug   -
               ServerLogging -
               ServerVerbose {}
           }


           switch $Method  {
                CreateSpectrum           -
                DeleteSpectrum           -
                ZeroSpectrum             {
                   if {$z != 0} then {
                      return -code error -errorcode "$m" -errorinfo "$Method: $PathName, [EGerrInfo $m]"
                   } else {
                      return ""
                   }
                }

                SpectrumDetails        -
                SpectrumGetTitle       -
                SpectrumPutTitle       -
                SpectrumGetLabel       -
                SpectrumPutLabel       -
                SpectrumGetInfo        -
                SpectrumPutInfo        -
                SpectrumGetCalib       -
                SpectrumPutCalib          {
                   if {$z != 0} then {
                      return -code error -errorcode "$m" -errorinfo "$Method: $PathName, [EGerrInfo $m]"
                   } else {
                      return $m
                   }
                }

                InquireSpectra     {
                   if {$z != 0} then {
                      return -code error -errorcode "$m" -errorinfo "$Method: $PathName, [EGerrInfo $m]"
                   } else {
                      set rc $m
                   }
                }

                ServerDebug   -
                ServerLogging -
                ServerVerbose {}
            }

         }   ;#  end of $RPCservers != ""

         set SOAPsrvs [tail $SOAPservers]
         if {[llength $SOAPsrvs] == 1} {
            set SOAPsrvs [first $SOAPsrvs]
         }
         foreach SOAPserver $SOAPsrvs {

#             set Info   [inform ex obtain_SOAPServerInfo $SOAPserver $server]
             set ServerInfo   [inform ex obtain_SOAPServerInfo $SOAPserver [head $SOAPservers]]
#  example info     memsas1 localhost:8015 Spectrum SpectrumServer SpectrumServer SpectrumClient

             set Class [lindex $ServerInfo 3]
             set Urn   [lindex $ServerInfo 4]
             set Cmd   [lindex $ServerInfo 5]

             if {$ServerAccessTrace} {insert-debug "Using SOAP  Server: $SOAPserver Cmd: $Cmd  Method: $Method Urn: $Urn  pathname: \"$pathname\"  args: $args"}

             package require $Cmd

             SOAP::configure [set Cmd]__$Method -proxy "http://$SOAPserver/$Urn" -uri "urn:$Urn"
             set LastSOAPMethodName [set Cmd]__$Method

             switch $Method  {

                CreateSpectrum         {
                    if {[fourth $args] == 0} {
                       set z [catch {[set Cmd]__$Method "$pathname" "[first $args]" "[second $args]"} reply]
                    } else {
                       set z [catch {[set Cmd]__$Method "$pathname" "[first $args]" "[second $args]" "[third $args]" "[fourth $args]"} reply]
                    }
                }

                Read1DSpectrum         {
                    set z [catch {[set Cmd]__[set Method]Text "$pathname" "[first $args]" "[second $args]"} reply]
                }

                DeleteSpectrum         -
                ZeroSpectrum           {
                    set z [catch {[set Cmd]__$Method "$pathname"} reply]
                }

                SpectrumDetails        {
                    set z [catch {[set Cmd]__$Method "$pathname"} reply]
                }

                SpectrumGetTitle          -
                SpectrumGetLabel          {
                    set z [catch {[set Cmd]__$Method "$pathname"} reply]
                }

                SpectrumPutTitle          -
                SpectrumPutLabel          {
                    set z [catch {[set Cmd]__$Method "$pathname" "[first $args]"} reply]
                }

                SpectrumGetInfo          -
                SpectrumGetCalib         {
                    set z [catch {[set Cmd]__$Method "$pathname" "[first $args]"} reply]
                }

                SpectrumPutInfo          -
                SpectrumPutCalib         {
                    set z [catch {[set Cmd]__$Method "$pathname" "[first $args]" "[second $args]"} reply]
                }

                InquireSpectra         {
                    set z [catch {[set Cmd]__$Method "$pathname"} reply]
                    if {$z != 0} {set reply ""}
                }

                ServerDebug            -
                ServerLogging          -
                ServerVerbose          {
                       set z [catch {[set Cmd]__$Method "[first $args]"} reply]
#                    set reply [[set Cmd]__$Method "[first $args]"]
                }
             }

             if {$ServerAccessTrace} {insert-debug "reply: $reply, length [llength $reply]"}

             switch $Method  {

                CreateSpectrum           -
                DeleteSpectrum           -
                ZeroSpectrum             {
                    if {$z==0} {return [first $reply]} {set rc $reply}   ;# done it and only one operation required
                }

                Read1DSpectrum     {
                    foreach r $reply {lappend rc $r}
                }

                SpectrumDetails          {
                    global CurrentSOAPserver CurrentUrn
# these are used by MIDASgetSpectrumServer which is called by the spectrum display tcl
                    if {$z==0} {
                       set CurrentSOAPserver $SOAPserver
                       set CurrentUrn $Urn
                       if {[llength $reply] == 1} {return [first $reply]} {return "$reply"}
                    } else {
                       set rc $reply
                    }   ;# done it and only one operation required
                }

                SpectrumPutTitle         -
                SpectrumPutLabel         -
                SpectrumPutCalib         -
                SpectrumPutInfo          {
                    if {$z==0} {return [first $reply]} {set rc $reply}   ;# done it and only one operation required
                }

                SpectrumGetInfo          -
                SpectrumGetTitle         -
                SpectrumGetLabel         -
                SpectrumGetCalib         {
                    if {$z==0} {
                       if {[llength $reply] == 1} {return [first $reply]} {return "$reply"}
                    } else {
                       set rc $reply
                    }
                }

                InquireSpectra     {
                    foreach r $reply {lappend rc $r}
                }

                ServerDebug              -
                ServerLogging            -
                ServerVerbose            {
                    if {$z==0 || $rc=={}} {set rc $reply}
                }
            }

         }   ;#   end of  "foreach SOAPserver $SOAPservers"

         if {$ServerAccessTrace} {
            insert-debug "MIDASSpectrumAccess: $Method $PathName NumArgs=[llength $args] Args=$args"
            insert-debug "returning $rc, length [llength [list $rc]]"
         }

         if {[regexp "0x\[13\]00??" $rc] == 1} then {
           return -code error -errorcode "$rc" -errorinfo "$Method: $PathName, [EGerrInfo $rc]"
         } else {
           return $rc
         }
 }


#    New style register access procedures
#      Name is of the form  /server/register   or    register
#      If omitted server defaults to to global variable MIDASAccessServer
#    return is a list:
#        first item of the list is the return code (rc)
#        if rc = 0  then the second item of the list is returned data (if any)
#        if rc != 0 then the second item of the list is an expansion of the error

proc MIDASCreateSpectrum        {Name Base Range Base2 Range2} {return [MIDASSpectrumAccess CreateSpectrum $Name $Base $Range $Base2 $Range2]}
proc MIDASDeleteSpectrum        {Name}            {return [MIDASSpectrumAccess DeleteSpectrum $Name]}
proc MIDASZeroSpectrum          {Name}            {return [MIDASSpectrumAccess ZeroSpectrum $Name]}
proc MIDASInquireSpectra        {Name}            {return [MIDASSpectrumAccess InquireSpectra $Name]}
proc MIDASRead1DSpectrum        {Name Base Range} {return [MIDASSpectrumAccess Read1DSpectrum $Name $Base $Range]}
proc MIDASRead2DSpectrum        {Name Base Range Base2 Range2} {return [MIDASSpectrumAccess Read2DSpectrum $Name $Base $Range $Base2 $Range2]}
proc MIDASSpectrumDetails       {Name}            {global CurrentSOAPserver CurrentUrn; # used by MIDASgetSpectrumServer
                                                   set CurrentSOAPserver ""; set CurrentUrn ""
                                                   return [MIDASSpectrumAccess SpectrumDetails $Name]}
proc MIDASReadSpectrumTitle     {Name}            {return [MIDASSpectrumAccess SpectrumGetTitle $Name]}
proc MIDASWriteSpectrumTitle    {Name Title}      {return [MIDASSpectrumAccess SpectrumPutTitle $Name $Title]}
proc MIDASReadSpectrumLabel     {Name}            {return [MIDASSpectrumAccess SpectrumGetLabel $Name]}
proc MIDASWriteSpectrumLabel    {Name Label}      {return [MIDASSpectrumAccess SpectrumPutLabel $Name $Label]}
proc MIDASReadSpectrumInfo      {Name Num}        {return [MIDASSpectrumAccess SpectrumGetInfo $Name $Num]}
proc MIDASWriteSpectrumInfo     {Name Num Info}   {return [MIDASSpectrumAccess SpectrumPutInfo $Name $Num $Info]}
proc MIDASReadSpectrumCalib     {Name Dim}        {return [MIDASSpectrumAccess SpectrumGetCalib $Name $Dim]}
proc MIDASWriteSpectrumCalib    {Name Dim Calib}  {return [MIDASSpectrumAccess SpectrumPutCalib $Name $Dim $Calib]}

proc MIDASSpectrumCompressions  {Name Compress1 Compress2} {return [MIDASSpectrumAccess SpectrumCompressions $Name $Compress1 $Compress2]}
proc MIDASSpectrumError         {Name Error}      {return [MIDASSpectrumAccess SpectrumError $Name $Error]}
proc MIDASSetSpectrumVerbose            {Name Value}      {return [MIDASSpectrumAccess ServerVerbose $Name $Value]}
proc MIDASSetSpectrumDebug              {Name Value}      {return [MIDASSpectrumAccess ServerDebug $Name $Value]}
proc MIDASSetSpectrumLogging            {Name Value}      {return [MIDASSpectrumAccess ServerLogging $Name $Value]}


proc MIDASgetSpectrumServer {Name} {
# used by the spectrum display tcl
   global CurrentSOAPserver CurrentUrn
      if {$CurrentSOAPserver=="" || $CurrentUrn==""} {
        return ""
      } else {
        return [list $CurrentSOAPserver $CurrentUrn]
      }
}
