/*
 * Decompiled with CFR 0.152.
 */
package cvupgradegui;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LastResortHandler
implements Thread.UncaughtExceptionHandler {
    @Override
    public void uncaughtException(Thread t, final Throwable e) {
        if (SwingUtilities.isEventDispatchThread()) {
            LastResortHandler.displayException(e);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LastResortHandler.displayException(e);
                }
            });
        }
    }

    public static void displayException(Throwable e) {
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        String message = "Unknown error";
        if (e.getLocalizedMessage() != null) {
            message = e.toString();
        } else if (e.getCause() != null && e.getCause().getLocalizedMessage() != null) {
            message = e.getCause().toString();
        }
        e.printStackTrace(System.err);
        JOptionPane.showMessageDialog(focusedWindow, message, "Fatal error", 0);
    }
}

