/*
 * Decompiled with CFR 0.152.
 */
package cvupgradegui;

import cvupgradegui.AppProperties;
import cvupgradegui.SimpleLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class BridgeUpdateThread
extends Thread {
    final String filename = AppProperties.BridgeUpgraderProgram;
    List<String> parms = new ArrayList<String>();
    Process proc = null;
    Writer procOS = null;
    BufferedReader procIS = null;
    SimpleLogger logger = null;
    int retval = -1318387531;
    FinishListener finishListener = null;

    BridgeUpdateThread() {
        this.parms.add(this.filename);
    }

    @Override
    public synchronized void run() {
        try {
            String line;
            if (this.logger != null) {
                line = "Run:";
                for (String s : this.parms) {
                    line = line + " " + s;
                }
                this.logger.println(line);
            }
            this.proc = new ProcessBuilder(this.parms).redirectErrorStream(true).start();
            this.procOS = new OutputStreamWriter(this.proc.getOutputStream());
            this.procIS = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            if (this.logger != null) {
                while ((line = this.procIS.readLine()) != null) {
                    this.logger.println("Output: " + line);
                }
            }
            this.retval = this.proc.waitFor();
        }
        catch (Exception ex) {
            Logger.getLogger(BridgeUpdateThread.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.notify();
        if (this.finishListener != null) {
            this.finishListener.finished(this.retval);
        }
    }

    public void startWithParms(String ... parms) {
        this.parms.clear();
        this.parms.add(this.filename);
        this.parms.addAll(Arrays.asList(parms));
        this.start();
    }

    public void startWithParms(List<String> parms) {
        this.parms.clear();
        this.parms.add(this.filename);
        this.parms.addAll(parms);
        this.start();
    }

    public synchronized int waitFor() throws InterruptedException {
        this.wait();
        return this.retval;
    }

    public void setFinishListener(FinishListener fl) {
        this.finishListener = fl;
    }

    public void setLogger(SimpleLogger logger) {
        this.logger = logger;
    }

    public static interface FinishListener
    extends EventListener {
        public void finished(int var1);
    }
}

